/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.Attribute;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x500.RDN;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extension;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extensions;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.X509CertificateHolder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.ContentVerifierProvider;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApprover
implements CertificateApprover {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateApprover.class);
    private final PKIProfile profile;
    private final SecurityConfig securityConfig;

    public BaseApprover(PKIProfile pkiProfile, SecurityConfig config) {
        this.profile = Objects.requireNonNull(pkiProfile);
        this.securityConfig = Objects.requireNonNull(config);
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    Attribute[] getAttributes(PKCS10CertificationRequest request) {
        Objects.requireNonNull(request);
        return request.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
    }

    List<Extensions> getExtensionsList(Attribute attribute) {
        Objects.requireNonNull(attribute);
        ArrayList<Extensions> extensionsList = new ArrayList<Extensions>();
        for (ASN1Encodable value : attribute.getAttributeValues()) {
            if (value == null) continue;
            Extensions extensions = Extensions.getInstance(value);
            extensionsList.add(extensions);
        }
        return extensionsList;
    }

    List<Extension> getIndividualExtension(Extensions extensions) {
        Objects.requireNonNull(extensions);
        ArrayList<Extension> extenList = new ArrayList<Extension>();
        for (ASN1ObjectIdentifier id : extensions.getExtensionOIDs()) {
            Extension ext;
            if (id == null || (ext = extensions.getExtension(id)) == null) continue;
            extenList.add(ext);
        }
        return extenList;
    }

    boolean verfiyExtensions(PKCS10CertificationRequest request) {
        Objects.requireNonNull(request);
        for (Attribute attr : this.getAttributes(request)) {
            for (Extensions extensionsList : this.getExtensionsList(attr)) {
                for (Extension extension : this.getIndividualExtension(extensionsList)) {
                    if (this.profile.validateExtension(extension)) continue;
                    LOG.error("Failed to verify extension. {}", (Object)extension.getExtnId().getId());
                    return false;
                }
            }
        }
        return true;
    }

    boolean verifyPkcs10Request(PKCS10CertificationRequest pkcs10Request) throws OperatorCreationException, PKCSException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(this.securityConfig.getProvider()).build(pkcs10Request.getSubjectPublicKeyInfo());
        return pkcs10Request.isSignatureValid(verifierProvider);
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(String csr) throws IOException {
        return this.inspectCSR(CertificateSignRequest.getCertificationRequest(csr));
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(PKCS10CertificationRequest csr) {
        CompletableFuture<X509CertificateHolder> response = new CompletableFuture<X509CertificateHolder>();
        try {
            if (!this.verifyPkcs10Request(csr)) {
                LOG.error("Failed to verify the signature in CSR.");
                response.completeExceptionally(new SCMSecurityException("Failed to verify the CSR."));
            }
            for (RDN rdn : csr.getSubject().getRDNs()) {
                if (this.profile.validateRDN(rdn)) continue;
                LOG.error("Failed in verifying RDNs");
                response.completeExceptionally(new SCMSecurityException("Failed to verify the RDNs. Please check the subject name."));
            }
            if (!this.verfiyExtensions(csr)) {
                LOG.error("failed in verification of extensions.");
                response.completeExceptionally(new SCMSecurityException("Failed to verify extensions."));
            }
        }
        catch (OperatorCreationException | PKCSException e) {
            LOG.error("Approval Failure.", (Throwable)e);
            response.completeExceptionally(new SCMSecurityException(e));
        }
        return response;
    }
}

