/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class OzoneBlockTokenIdentifier
extends TokenIdentifier {
    static final Text KIND_NAME = new Text("HDDS_BLOCK_TOKEN");
    private long expiryDate;
    private String ownerId;
    private String blockId;
    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes;
    private String omCertSerialId;
    private long maxLength;

    public OzoneBlockTokenIdentifier() {
    }

    public OzoneBlockTokenIdentifier(String ownerId, String blockId, EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long expiryDate, String omCertSerialId, long maxLength) {
        this.ownerId = ownerId;
        this.blockId = blockId;
        this.expiryDate = expiryDate;
        this.modes = modes == null ? EnumSet.noneOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class) : modes;
        this.omCertSerialId = omCertSerialId;
        this.maxLength = maxLength;
    }

    public UserGroupInformation getUser() {
        if (Strings.isNullOrEmpty(this.getOwnerId())) {
            return UserGroupInformation.createRemoteUser((String)this.blockId);
        }
        return UserGroupInformation.createRemoteUser((String)this.ownerId);
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAccessModes() {
        return this.modes;
    }

    public String getOmCertSerialId() {
        return this.omCertSerialId;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public String toString() {
        return "block_token_identifier (expiryDate=" + this.getExpiryDate() + ", ownerId=" + this.getOwnerId() + ", omCertSerialId=" + this.getOmCertSerialId() + ", blockId=" + this.getBlockId() + ", access modes=" + this.getAccessModes() + ", maxLength=" + this.getMaxLength() + ")";
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OzoneBlockTokenIdentifier) {
            OzoneBlockTokenIdentifier that = (OzoneBlockTokenIdentifier)((Object)obj);
            return new EqualsBuilder().append(this.expiryDate, that.expiryDate).append((Object)this.ownerId, (Object)that.ownerId).append((Object)this.blockId, (Object)that.blockId).append(this.modes, that.modes).append((Object)this.omCertSerialId, (Object)that.omCertSerialId).append(this.maxLength, that.maxLength).build();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(133, 567).append(this.expiryDate).append((Object)this.blockId).append((Object)this.ownerId).append(this.modes).append((Object)this.omCertSerialId).append(this.maxLength).build();
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        if (!dis.markSupported()) {
            throw new IOException("Could not peek first byte.");
        }
        HddsProtos.BlockTokenSecretProto tokenPtoto = HddsProtos.BlockTokenSecretProto.parseFrom((DataInputStream)in);
        this.ownerId = tokenPtoto.getOwnerId();
        this.blockId = tokenPtoto.getBlockId();
        this.modes = EnumSet.copyOf(tokenPtoto.getModesList());
        this.expiryDate = tokenPtoto.getExpiryDate();
        this.omCertSerialId = tokenPtoto.getOmCertSerialId();
        this.maxLength = tokenPtoto.getMaxLength();
    }

    @VisibleForTesting
    public static OzoneBlockTokenIdentifier readFieldsProtobuf(DataInput in) throws IOException {
        HddsProtos.BlockTokenSecretProto tokenPtoto = HddsProtos.BlockTokenSecretProto.parseFrom((DataInputStream)in);
        return new OzoneBlockTokenIdentifier(tokenPtoto.getOwnerId(), tokenPtoto.getBlockId(), EnumSet.copyOf(tokenPtoto.getModesList()), tokenPtoto.getExpiryDate(), tokenPtoto.getOmCertSerialId(), tokenPtoto.getMaxLength());
    }

    public void write(DataOutput out) throws IOException {
        this.writeProtobuf(out);
    }

    @VisibleForTesting
    void writeProtobuf(DataOutput out) throws IOException {
        HddsProtos.BlockTokenSecretProto.Builder builder = HddsProtos.BlockTokenSecretProto.newBuilder().setBlockId(this.getBlockId()).setOwnerId(this.getOwnerId()).setOmCertSerialId(this.getOmCertSerialId()).setExpiryDate(this.getExpiryDate()).setMaxLength(this.getMaxLength());
        for (HddsProtos.BlockTokenSecretProto.AccessModeProto mode : this.getAccessModes()) {
            builder.addModes(HddsProtos.BlockTokenSecretProto.AccessModeProto.valueOf(mode.name()));
        }
        out.write(builder.build().toByteArray());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

