/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolClientSideTranslatorPB
implements StorageContainerLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final StorageContainerLocationProtocolPB rpcProxy;

    public StorageContainerLocationProtocolClientSideTranslatorPB(StorageContainerLocationProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    private StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(StorageContainerLocationProtocolProtos.Type type, Consumer<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder> builderConsumer) throws IOException {
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response;
        try {
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder builder = StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.newBuilder().setCmdType(type).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest wrapper = builder.build();
            response = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    @Override
    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerRequestProto request = StorageContainerLocationProtocolProtos.ContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setReplicationFactor(factor).setReplicationType(type).setOwner(owner).build();
        StorageContainerLocationProtocolProtos.ContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocateContainer, builder -> builder.setContainerRequest(request)).getContainerResponse();
        if (response.getErrorCode() != StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate container failed.");
        }
        return ContainerWithPipeline.fromProtobuf(response.getContainerWithPipeline());
    }

    @Override
    public ContainerInfo getContainer(long containerID) throws IOException {
        Preconditions.checkState(containerID >= 0L, "Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerRequestProto request = StorageContainerLocationProtocolProtos.GetContainerRequestProto.newBuilder().setContainerID(containerID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainer, builder -> builder.setGetContainerRequest(request));
        return ContainerInfo.fromProtobuf(response.getGetContainerResponse().getContainerInfo());
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        Preconditions.checkState(containerID >= 0L, "Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerWithPipeline, builder -> builder.setGetContainerWithPipelineRequest(request));
        return ContainerWithPipeline.fromProtobuf(response.getGetContainerWithPipelineResponse().getContainerWithPipeline());
    }

    @Override
    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        Preconditions.checkState(startContainerID >= 0L, "Container ID cannot be negative.");
        Preconditions.checkState(count > 0, "Container count must be greater than 0.");
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.newBuilder();
        builder.setStartContainerID(startContainerID);
        builder.setCount(count);
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListContainer, builder1 -> builder1.setScmListContainerRequest(request)).getScmListContainerResponse();
        ArrayList<ContainerInfo> containerList = new ArrayList<ContainerInfo>();
        for (HddsProtos.ContainerInfoProto containerInfoProto : response.getContainersList()) {
            containerList.add(ContainerInfo.fromProtobuf(containerInfoProto));
        }
        return containerList;
    }

    @Override
    public void deleteContainer(long containerID) throws IOException {
        Preconditions.checkState(containerID >= 0L, "Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeleteContainer, builder -> builder.setScmDeleteContainerRequest(request));
    }

    @Override
    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState nodeStatuses, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        Preconditions.checkNotNull(nodeStatuses);
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto request = StorageContainerLocationProtocolProtos.NodeQueryRequestProto.newBuilder().setState(nodeStatuses).setTraceID(TracingUtil.exportCurrentSpan()).setScope(queryScope).setPoolName(poolName).build();
        StorageContainerLocationProtocolProtos.NodeQueryResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.QueryNode, builder -> builder.setNodeQueryRequest(request)).getNodeQueryResponse();
        return response.getDatanodesList();
    }

    @Override
    public void closeContainer(long containerID) throws IOException {
        Preconditions.checkState(containerID >= 0L, "Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.CloseContainer, builder -> builder.setScmCloseContainerRequest(request));
    }

    @Override
    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        StorageContainerLocationProtocolProtos.PipelineRequestProto request = StorageContainerLocationProtocolProtos.PipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setNodePool(nodePool).setReplicationFactor(factor).setReplicationType(replicationType).build();
        StorageContainerLocationProtocolProtos.PipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocatePipeline, builder -> builder.setPipelineRequest(request)).getPipelineResponse();
        if (response.getErrorCode() == StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success) {
            Preconditions.checkState(response.hasPipeline(), "With success, must come a pipeline");
            return Pipeline.getFromProtobuf(response.getPipeline());
        }
        String errorMessage = String.format("create replication pipeline failed. code : %s Message: %s", response.getErrorCode(), response.hasErrorMessage() ? response.getErrorMessage() : "");
        throw new IOException(errorMessage);
    }

    @Override
    public List<Pipeline> listPipelines() throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineRequestProto request = StorageContainerLocationProtocolProtos.ListPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListPipelines, builder -> builder.setListPipelineRequest(request)).getListPipelineResponse();
        ArrayList<Pipeline> list = new ArrayList<Pipeline>();
        for (HddsProtos.Pipeline pipeline : response.getPipelinesList()) {
            Pipeline fromProtobuf = Pipeline.getFromProtobuf(pipeline);
            list.add(fromProtobuf);
        }
        return list;
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetPipelineRequestProto.newBuilder().setPipelineID(pipelineID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetPipeline, builder -> builder.setGetPipelineRequest(request)).getGetPipelineResponse();
        return Pipeline.getFromProtobuf(response.getPipeline());
    }

    @Override
    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ActivatePipeline, builder -> builder.setActivatePipelineRequest(request));
    }

    @Override
    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeactivatePipeline, builder -> builder.setDeactivatePipelineRequest(request));
    }

    @Override
    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request = StorageContainerLocationProtocolProtos.ClosePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ClosePipeline, builder -> builder.setClosePipelineRequest(request));
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        HddsProtos.GetScmInfoResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetScmInfo, builder -> builder.setGetScmInfoRequest(request)).getGetScmInfoResponse();
        ScmInfo.Builder builder2 = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId());
        return builder2.build();
    }

    @Override
    public boolean inSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.InSafeModeRequestProto request = StorageContainerLocationProtocolProtos.InSafeModeRequestProto.getDefaultInstance();
        return this.submitRequest(StorageContainerLocationProtocolProtos.Type.InSafeMode, builder -> builder.setInSafeModeRequest(request)).getInSafeModeResponse().getInSafeMode();
    }

    @Override
    public boolean forceExitSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request = StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ForceExitSafeMode, builder -> builder.setForceExitSafeModeRequest(request)).getForceExitSafeModeResponse();
        return resp.getExitedSafeMode();
    }

    @Override
    public void startReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartReplicationManager, builder -> builder.setStartReplicationManagerRequest(request));
    }

    @Override
    public void stopReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StopReplicationManager, builder -> builder.setStopReplicationManagerRequest(request));
    }

    @Override
    public boolean getReplicationManagerStatus() throws IOException {
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request = StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetReplicationManagerStatus, builder -> builder.setSeplicationManagerStatusRequest(request)).getReplicationManagerStatusResponse();
        return response.getIsRunning();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

