/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class MockPipeline {
    public static Pipeline createSingleNodePipeline() throws IOException {
        return MockPipeline.createPipeline(1);
    }

    public static Pipeline createPipeline(int numNodes) throws IOException {
        Preconditions.checkArgument(numNodes >= 1);
        ArrayList<DatanodeDetails> ids = new ArrayList<DatanodeDetails>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            ids.add(MockDatanodeDetails.randomLocalDatanodeDetails());
        }
        return MockPipeline.createPipeline(ids);
    }

    public static Pipeline createPipeline(Iterable<DatanodeDetails> ids) {
        Objects.requireNonNull(ids, "ids == null");
        Preconditions.checkArgument(ids.iterator().hasNext());
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>();
        ids.forEach(dns::add);
        return Pipeline.newBuilder().setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setType(HddsProtos.ReplicationType.STAND_ALONE).setFactor(HddsProtos.ReplicationFactor.ONE).setNodes(dns).build();
    }

    private MockPipeline() {
        throw new UnsupportedOperationException("no instances");
    }
}

