/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hdds.scm.net.NodeSchemaLoader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class TestNodeSchemaLoader {
    private static void assertMessageContains(String actual, String expected, String testCase) {
        if (!actual.contains(expected)) {
            Assert.fail((String)String.format("Expected message for '%s' to contain '%s', but got: '%s'", testCase, expected, actual));
        }
    }

    private static String getClassloaderResourcePath(String file) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("networkTopologyTestFiles/" + file);
        Assert.assertNotNull((Object)resource);
        return resource.getPath();
    }

    public static class NonParameterizedTests {
        private static final String VALID_SCHEMA_FILE = "good.xml";
        @Rule
        public Timeout testTimeout = new Timeout(2000);

        @Test
        public void testGood() throws Exception {
            String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(VALID_SCHEMA_FILE);
            NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath);
        }

        @Test
        public void testNotExist() {
            String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(VALID_SCHEMA_FILE).replace(VALID_SCHEMA_FILE, "non-existent.xml");
            Exception e = (Exception)Assertions.assertThrows(FileNotFoundException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
            TestNodeSchemaLoader.assertMessageContains(e.getMessage(), "not found", "non-existent.xml");
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ParameterizedTests {
        private final String schemaFile;
        private final String errMsg;
        @Rule
        public Timeout testTimeout = new Timeout(2000);

        @Parameterized.Parameters
        public static Collection<Object[]> getSchemaFiles() {
            Object[][] schemaFiles = new Object[][]{{"enforce-error.xml", "layer without prefix defined"}, {"invalid-cost.xml", "Cost should be positive number or 0"}, {"multiple-leaf.xml", "Multiple LEAF layers are found"}, {"multiple-root.xml", "Multiple ROOT layers are found"}, {"no-leaf.xml", "No LEAF layer is found"}, {"no-root.xml", "No ROOT layer is found"}, {"path-layers-size-mismatch.xml", "Topology path depth doesn't match layer element numbers"}, {"path-with-id-reference-failure.xml", "No layer found for id"}, {"unknown-layer-type.xml", "Unsupported layer type"}, {"wrong-path-order-1.xml", "Topology path doesn't start with ROOT layer"}, {"wrong-path-order-2.xml", "Topology path doesn't end with LEAF layer"}, {"no-topology.xml", "no or multiple <topology> element"}, {"multiple-topology.xml", "no or multiple <topology> element"}, {"invalid-version.xml", "Bad layoutversion value"}, {"external-entity.xml", "accessExternalDTD"}};
            return Arrays.asList(schemaFiles);
        }

        public ParameterizedTests(String schemaFile, String errMsg) {
            this.schemaFile = schemaFile;
            this.errMsg = errMsg;
        }

        @Test
        public void testInvalid() {
            String filePath = TestNodeSchemaLoader.getClassloaderResourcePath(this.schemaFile);
            Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath));
            TestNodeSchemaLoader.assertMessageContains(e.getMessage(), this.errMsg, this.schemaFile);
        }
    }
}

