/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaLoader;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(NodeSchemaManager.class);
    private List<NodeSchema> allSchema;
    private boolean enforcePrefix;
    private int maxLevel = -1;
    private static volatile NodeSchemaManager instance = null;

    private NodeSchemaManager() {
    }

    public static NodeSchemaManager getInstance() {
        if (instance == null) {
            instance = new NodeSchemaManager();
        }
        return instance;
    }

    public void init(Configuration conf) {
        String schemaFile = conf.get("ozone.scm.network.topology.schema.file", "network-topology-default.xml");
        try {
            NodeSchemaLoader.NodeSchemaLoadResult result = NodeSchemaLoader.getInstance().loadSchemaFromFile(schemaFile);
            this.allSchema = result.getSchemaList();
            this.enforcePrefix = result.isEnforePrefix();
            this.maxLevel = this.allSchema.size();
        }
        catch (Throwable e) {
            String msg = "Failed to load schema file:" + schemaFile + ", error: " + e.getMessage();
            LOG.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    @VisibleForTesting
    public void init(NodeSchema[] schemas, boolean enforce) {
        this.allSchema = new ArrayList<NodeSchema>();
        this.allSchema.addAll(Arrays.asList(schemas));
        this.enforcePrefix = enforce;
        this.maxLevel = schemas.length;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getCost(int level) {
        Preconditions.checkArgument(level <= this.maxLevel && level >= 1);
        return this.allSchema.get(level - 1).getCost();
    }

    public String complete(String path) {
        if (!this.enforcePrefix) {
            return null;
        }
        String normalizedPath = NetUtils.normalize(path);
        String[] subPath = normalizedPath.split("/");
        if (subPath.length == this.maxLevel) {
            return path;
        }
        StringBuffer newPath = new StringBuffer("");
        int i = 1;
        int j = 1;
        while (i < subPath.length && j < this.allSchema.size() - 1) {
            if (this.allSchema.get(j).matchPrefix(subPath[i])) {
                newPath.append("/" + subPath[i]);
                ++i;
                ++j;
                continue;
            }
            newPath.append(this.allSchema.get(j).getDefaultName());
            ++j;
        }
        if (i == subPath.length - 1) {
            newPath.append("/" + subPath[i]);
            return newPath.toString();
        }
        return null;
    }
}

