/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;

public class ContainerInfo
implements Comparator<ContainerInfo>,
Comparable<ContainerInfo>,
Externalizable {
    private static final ObjectWriter WRITER;
    private static final String SERIALIZATION_ERROR_MSG = "Java serialization not supported. Use protobuf instead.";
    private HddsProtos.LifeCycleState state;
    @JsonIgnore
    private PipelineID pipelineID;
    private HddsProtos.ReplicationFactor replicationFactor;
    private HddsProtos.ReplicationType replicationType;
    private long usedBytes;
    private long numberOfKeys;
    private long lastUsed;
    private long stateEnterTime;
    private String owner;
    private long containerID;
    private long deleteTransactionId;
    private long sequenceId;
    @JsonIgnore
    private byte[] data;

    ContainerInfo(long containerID, HddsProtos.LifeCycleState state, PipelineID pipelineID, long usedBytes, long numberOfKeys, long stateEnterTime, String owner, long deleteTransactionId, long sequenceId, HddsProtos.ReplicationFactor replicationFactor, HddsProtos.ReplicationType repType) {
        this.containerID = containerID;
        this.pipelineID = pipelineID;
        this.usedBytes = usedBytes;
        this.numberOfKeys = numberOfKeys;
        this.lastUsed = Time.monotonicNow();
        this.state = state;
        this.stateEnterTime = stateEnterTime;
        this.owner = owner;
        this.deleteTransactionId = deleteTransactionId;
        this.sequenceId = sequenceId;
        this.replicationFactor = replicationFactor;
        this.replicationType = repType;
    }

    public ContainerInfo() {
    }

    public static ContainerInfo fromProtobuf(HddsProtos.ContainerInfoProto info) {
        Builder builder = new Builder();
        return builder.setPipelineID(PipelineID.getFromProtobuf(info.getPipelineID())).setUsedBytes(info.getUsedBytes()).setNumberOfKeys(info.getNumberOfKeys()).setState(info.getState()).setStateEnterTime(info.getStateEnterTime()).setOwner(info.getOwner()).setContainerID(info.getContainerID()).setDeleteTransactionId(info.getDeleteTransactionId()).setReplicationFactor(info.getReplicationFactor()).setReplicationType(info.getReplicationType()).build();
    }

    public long getContainerID() {
        return this.containerID;
    }

    public HddsProtos.LifeCycleState getState() {
        return this.state;
    }

    public void setState(HddsProtos.LifeCycleState state) {
        this.state = state;
    }

    public long getStateEnterTime() {
        return this.stateEnterTime;
    }

    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public PipelineID getPipelineID() {
        return this.pipelineID;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public void setUsedBytes(long value) {
        this.usedBytes = value;
    }

    public long getNumberOfKeys() {
        return this.numberOfKeys;
    }

    public void setNumberOfKeys(long value) {
        this.numberOfKeys = value;
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public void updateSequenceId(long sequenceID) {
        assert (this.isOpen() || this.state == HddsProtos.LifeCycleState.QUASI_CLOSED);
        this.sequenceId = Math.max(sequenceID, this.sequenceId);
    }

    public ContainerID containerID() {
        return new ContainerID(this.getContainerID());
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public HddsProtos.ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public void updateLastUsedTime() {
        this.lastUsed = Time.monotonicNow();
    }

    public HddsProtos.ContainerInfoProto getProtobuf() {
        HddsProtos.ContainerInfoProto.Builder builder = HddsProtos.ContainerInfoProto.newBuilder();
        Preconditions.checkState(this.containerID > 0L);
        return builder.setContainerID(this.getContainerID()).setUsedBytes(this.getUsedBytes()).setNumberOfKeys(this.getNumberOfKeys()).setState(this.getState()).setStateEnterTime(this.getStateEnterTime()).setContainerID(this.getContainerID()).setDeleteTransactionId(this.getDeleteTransactionId()).setPipelineID(this.getPipelineID().getProtobuf()).setReplicationFactor(this.getReplicationFactor()).setReplicationType(this.getReplicationType()).setOwner(this.getOwner()).build();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return "ContainerInfo{id=" + this.containerID + ", state=" + this.state + ", pipelineID=" + this.pipelineID + ", stateEnterTime=" + this.stateEnterTime + ", owner=" + this.owner + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        return new EqualsBuilder().append(this.getContainerID(), that.getContainerID()).append((Object)this.owner, (Object)that.owner).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 811).append(this.getContainerID()).append((Object)this.getOwner()).toHashCode();
    }

    @Override
    public int compare(ContainerInfo o1, ContainerInfo o2) {
        return Long.compare(o1.getLastUsed(), o2.getLastUsed());
    }

    @Override
    public int compareTo(ContainerInfo o) {
        return this.compare(this, o);
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString(this);
    }

    public byte[] getData() {
        if (this.data != null) {
            return Arrays.copyOf(this.data, this.data.length);
        }
        return null;
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.data = Arrays.copyOf(data, data.length);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IOException(SERIALIZATION_ERROR_MSG);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IOException(SERIALIZATION_ERROR_MSG);
    }

    public boolean isOpen() {
        return this.state == HddsProtos.LifeCycleState.OPEN || this.state == HddsProtos.LifeCycleState.CLOSING;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    public static class Builder {
        private HddsProtos.LifeCycleState state;
        private long used;
        private long keys;
        private long stateEnterTime;
        private String owner;
        private long containerID;
        private long deleteTransactionId;
        private long sequenceId;
        private PipelineID pipelineID;
        private HddsProtos.ReplicationFactor replicationFactor;
        private HddsProtos.ReplicationType replicationType;

        public Builder setReplicationType(HddsProtos.ReplicationType repType) {
            this.replicationType = repType;
            return this;
        }

        public Builder setPipelineID(PipelineID pipelineId) {
            this.pipelineID = pipelineId;
            return this;
        }

        public Builder setReplicationFactor(HddsProtos.ReplicationFactor repFactor) {
            this.replicationFactor = repFactor;
            return this;
        }

        public Builder setContainerID(long id) {
            Preconditions.checkState(id >= 0L);
            this.containerID = id;
            return this;
        }

        public Builder setState(HddsProtos.LifeCycleState lifeCycleState) {
            this.state = lifeCycleState;
            return this;
        }

        public Builder setUsedBytes(long bytesUsed) {
            this.used = bytesUsed;
            return this;
        }

        public Builder setNumberOfKeys(long keyCount) {
            this.keys = keyCount;
            return this;
        }

        public Builder setStateEnterTime(long time) {
            this.stateEnterTime = time;
            return this;
        }

        public Builder setOwner(String containerOwner) {
            this.owner = containerOwner;
            return this;
        }

        public Builder setDeleteTransactionId(long deleteTransactionID) {
            this.deleteTransactionId = deleteTransactionID;
            return this;
        }

        public Builder setSequenceId(long sequenceID) {
            this.sequenceId = sequenceID;
            return this;
        }

        public ContainerInfo build() {
            return new ContainerInfo(this.containerID, this.state, this.pipelineID, this.used, this.keys, this.stateEnterTime, this.owner, this.deleteTransactionId, this.sequenceId, this.replicationFactor, this.replicationType);
        }
    }
}

