/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.primitives.Longs;

public final class ContainerID
implements Comparable<ContainerID> {
    private final long id;

    public ContainerID(long id) {
        this.id = id;
    }

    public static ContainerID valueof(long containerID) {
        Preconditions.checkState(containerID > 0L, "Container ID should be a positive long. " + containerID);
        return new ContainerID(containerID);
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return Longs.toByteArray(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerID that = (ContainerID)o;
        return new EqualsBuilder().append(this.getId(), that.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append(this.getId()).toHashCode();
    }

    @Override
    public int compareTo(ContainerID that) {
        Preconditions.checkNotNull(that);
        return new CompareToBuilder().append(this.getId(), that.getId()).build();
    }

    public String toString() {
        return "#" + this.id;
    }
}

