/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.pipeline.PipelineCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all active pipelines"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListPipelinesSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private PipelineCommands parent;
    @CommandLine.Option(names={"-ffc", "--filterByFactor"}, description={"Filter listed pipelines by Factor(ONE/one)"}, defaultValue="", required=false)
    private String factor;
    @CommandLine.Option(names={"-fst", "--filterByState"}, description={"Filter listed pipelines by State(OPEN/CLOSE)"}, defaultValue="", required=false)
    private String state;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            if (Strings.isNullOrEmpty(this.factor) && Strings.isNullOrEmpty(this.state)) {
                scmClient.listPipelines().forEach(System.out::println);
            } else {
                scmClient.listPipelines().stream().filter(p -> !(!Strings.isNullOrEmpty(this.factor) && p.getFactor().toString().compareToIgnoreCase(this.factor) != 0 || !Strings.isNullOrEmpty(this.state) && p.getPipelineState().toString().compareToIgnoreCase(this.state) != 0)).forEach(System.out::println);
            }
            Void void_ = null;
            return void_;
        }
    }
}

