/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.pipeline.PipelineCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

@CommandLine.Command(name="create", description={"create pipeline"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CreatePipelineSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private PipelineCommands parent;
    @CommandLine.Option(names={"-t", "--replicationType"}, description={"Replication type (STAND_ALONE, RATIS)"}, defaultValue="STAND_ALONE")
    private HddsProtos.ReplicationType type = HddsProtos.ReplicationType.STAND_ALONE;
    @CommandLine.Option(names={"-f", "--replicationFactor"}, description={"Replication factor (ONE, THREE)"}, defaultValue="ONE")
    private HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.ONE;

    @Override
    public Void call() throws Exception {
        if (this.type == HddsProtos.ReplicationType.CHAINED) {
            throw new IllegalArgumentException(this.type.name() + " is not supported yet.");
        }
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            Pipeline pipeline = scmClient.createReplicationPipeline(this.type, this.factor, HddsProtos.NodePool.getDefaultInstance());
            if (pipeline != null) {
                System.out.println(pipeline.getId().toString() + " is created. Factor: " + pipeline.getFactor() + ", Type: " + pipeline.getType());
            }
            Void void_ = null;
            return void_;
        }
    }
}

