/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.datanode.DatanodeCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

@CommandLine.Command(name="list", description={"List info of datanodes"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListInfoSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private DatanodeCommands parent;
    @CommandLine.Option(names={"--ip"}, description={"Show info by ip address."}, defaultValue="", required=false)
    private String ipaddress;
    @CommandLine.Option(names={"--id"}, description={"Show info by datanode UUID."}, defaultValue="", required=false)
    private String uuid;
    private List<Pipeline> pipelines;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            this.pipelines = scmClient.listPipelines();
            if (Strings.isNullOrEmpty(this.ipaddress) && Strings.isNullOrEmpty(this.uuid)) {
                this.getAllNodes(scmClient).stream().forEach(p -> this.printDatanodeInfo((DatanodeDetails)p));
            } else {
                Stream<Object> allNodes = this.getAllNodes(scmClient).stream();
                if (!Strings.isNullOrEmpty(this.ipaddress)) {
                    allNodes = allNodes.filter(p -> p.getIpAddress().compareToIgnoreCase(this.ipaddress) == 0);
                }
                if (!Strings.isNullOrEmpty(this.uuid)) {
                    allNodes = allNodes.filter(p -> p.getUuid().toString().equals(this.uuid));
                }
                allNodes.forEach(p -> this.printDatanodeInfo((DatanodeDetails)p));
            }
            Void void_ = null;
            return void_;
        }
    }

    private List<DatanodeDetails> getAllNodes(ScmClient scmClient) throws IOException {
        List<HddsProtos.Node> nodes = scmClient.queryNode(HddsProtos.NodeState.HEALTHY, HddsProtos.QueryScope.CLUSTER, "");
        return nodes.stream().map(p -> DatanodeDetails.getFromProtoBuf(p.getNodeID())).collect(Collectors.toList());
    }

    private void printDatanodeInfo(DatanodeDetails datanode) {
        StringBuilder pipelineListInfo = new StringBuilder();
        int relatedPipelineNum = 0;
        if (!this.pipelines.isEmpty()) {
            List relatedPipelines = this.pipelines.stream().filter(p -> p.getNodes().contains(datanode)).collect(Collectors.toList());
            if (relatedPipelines.isEmpty()) {
                pipelineListInfo.append("No related pipelines or the node is not in Healthy state.");
            } else {
                relatedPipelineNum = relatedPipelines.size();
                relatedPipelines.stream().forEach(p -> pipelineListInfo.append(p.getId().getId().toString()).append("/").append(p.getFactor().toString()).append("/").append(p.getType().toString()).append("/").append(p.getPipelineState().toString()).append("/").append(datanode.getUuid().equals(p.getLeaderId()) ? "Leader" : "Follower").append(System.getProperty("line.separator")));
            }
        } else {
            pipelineListInfo.append("No pipelines in cluster.");
        }
        System.out.println("Datanode: " + datanode.getUuid().toString() + " (" + datanode.getNetworkLocation() + "/" + datanode.getIpAddress() + "/" + datanode.getHostName() + "/" + relatedPipelineNum + " pipelines) \n" + "Related pipelines: \n" + pipelineListInfo);
    }
}

