/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.container.ContainerCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandLine.Command(name="list", description={"List containers"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ListSubcommand.class);
    @CommandLine.ParentCommand
    private ContainerCommands parent;
    @CommandLine.Option(names={"-s", "--start"}, description={"Container id to start the iteration"}, required=false)
    private long startId = 0L;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of containers to list"}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count = 20;

    private void outputContainerInfo(ContainerInfo containerInfo) throws IOException {
        LOG.info("{}", (Object)containerInfo.toJsonString());
    }

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            List<ContainerInfo> containerList = scmClient.listContainer(this.startId, this.count);
            for (ContainerInfo container : containerList) {
                this.outputContainerInfo(container);
            }
            Iterator<ContainerInfo> iterator = null;
            return iterator;
        }
    }
}

