/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.container.ContainerCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DeleteSubcommand
implements Callable<Void> {
    @CommandLine.Parameters(description={"Id of the container to close"})
    private long containerId;
    @CommandLine.Option(names={"-f", "--force"}, description={"forcibly delete the container"})
    private boolean force;
    @CommandLine.ParentCommand
    private ContainerCommands parent;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            this.parent.getParent().checkContainerExists(scmClient, this.containerId);
            scmClient.deleteContainer(this.containerId, this.force);
            Void void_ = null;
            return void_;
        }
    }
}

