/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.SCMCLI;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

@CommandLine.Command(name="printTopology", description={"Print a tree of the network topology as reported by SCM"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TopologySubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private SCMCLI parent;
    private static List<HddsProtos.NodeState> stateArray = new ArrayList<HddsProtos.NodeState>();
    @CommandLine.Option(names={"-o", "--order"}, description={"Print Topology ordered by network location"})
    private boolean order;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.createScmClient();){
            for (HddsProtos.NodeState state : stateArray) {
                List<HddsProtos.Node> nodes = scmClient.queryNode(state, HddsProtos.QueryScope.CLUSTER, "");
                if (nodes == null || nodes.size() <= 0) continue;
                System.out.println("State = " + state.toString());
                if (this.order) {
                    this.printOrderedByLocation(nodes);
                    continue;
                }
                this.printNodesWithLocation(nodes);
            }
            Iterator<HddsProtos.NodeState> iterator = null;
            return iterator;
        }
    }

    private void printOrderedByLocation(List<HddsProtos.Node> nodes) {
        HashMap tree = new HashMap();
        for (HddsProtos.Node node : nodes) {
            String location2 = node.getNodeID().getNetworkLocation();
            if (location2 != null && !tree.containsKey(location2)) {
                tree.put(location2, new TreeSet());
            }
            ((TreeSet)tree.get(location2)).add(DatanodeDetails.getFromProtoBuf(node.getNodeID()));
        }
        ArrayList locations = new ArrayList(tree.keySet());
        Collections.sort(locations);
        locations.forEach(location -> {
            System.out.println("Location: " + location);
            ((TreeSet)tree.get(location)).forEach(node -> System.out.println(" " + node.getIpAddress() + "(" + node.getHostName() + ")"));
        });
    }

    private void printNodesWithLocation(Collection<HddsProtos.Node> nodes) {
        nodes.forEach(node -> {
            System.out.print(" " + node.getNodeID().getIpAddress() + "(" + node.getNodeID().getHostName() + ")");
            System.out.println("    " + (node.getNodeID().getNetworkLocation() != null ? node.getNodeID().getNetworkLocation() : "NA"));
        });
    }

    static {
        stateArray.add(HddsProtos.NodeState.HEALTHY);
        stateArray.add(HddsProtos.NodeState.STALE);
        stateArray.add(HddsProtos.NodeState.DEAD);
        stateArray.add(HddsProtos.NodeState.DECOMMISSIONING);
        stateArray.add(HddsProtos.NodeState.DECOMMISSIONED);
    }
}

