/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.SafeModeCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandLine.Command(name="exit", description={"Force SCM out of safe mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeExitSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SafeModeExitSubcommand.class);
    @CommandLine.ParentCommand
    private SafeModeCommands parent;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            boolean execReturn = scmClient.forceExitSafeMode();
            if (execReturn) {
                LOG.info("SCM exit safe mode successfully.");
            }
            Void void_ = null;
            return void_;
        }
    }
}

