/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.SafeModeCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandLine.Command(name="status", description={"Check if SCM is in safe mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeCheckSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SafeModeCheckSubcommand.class);
    @CommandLine.ParentCommand
    private SafeModeCommands parent;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.getParent().createScmClient();){
            boolean execReturn = scmClient.inSafeMode();
            if (execReturn) {
                LOG.info("SCM is in safe mode.");
            } else {
                LOG.info("SCM is out of safe mode.");
            }
            Void void_ = null;
            return void_;
        }
    }
}

