/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.cli.ReplicationManagerCommands;
import org.apache.hadoop.hdds.scm.cli.SafeModeCommands;
import org.apache.hadoop.hdds.scm.cli.TopologySubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ContainerCommands;
import org.apache.hadoop.hdds.scm.cli.datanode.DatanodeCommands;
import org.apache.hadoop.hdds.scm.cli.pipeline.PipelineCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

@CommandLine.Command(name="ozone scmcli", hidden=true, description={"Developer tools to handle SCM specific operations."}, versionProvider=HddsVersionProvider.class, subcommands={SafeModeCommands.class, ContainerCommands.class, PipelineCommands.class, DatanodeCommands.class, TopologySubcommand.class, ReplicationManagerCommands.class}, mixinStandardHelpOptions=true)
public class SCMCLI
extends GenericCli {
    @CommandLine.Option(names={"--scm"}, description={"The destination scm (host:port)"})
    private String scm = "";

    public static void main(String[] argv) throws Exception {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        new SCMCLI().run(argv);
    }

    public ScmClient createScmClient() throws IOException {
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        this.checkAndSetSCMAddressArg(ozoneConf);
        return new ContainerOperationClient(ozoneConf);
    }

    public void checkContainerExists(ScmClient scmClient, long containerId) throws IOException {
        ContainerInfo container = scmClient.getContainer(containerId);
        if (container == null) {
            throw new IllegalArgumentException("No such container " + containerId);
        }
    }

    private void checkAndSetSCMAddressArg(Configuration conf) {
        if (StringUtils.isNotEmpty((CharSequence)this.scm)) {
            conf.set("ozone.scm.client.address", this.scm);
        }
        if (!HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address").isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address should be set in ozone-site.xml or with the --scm option");
        }
    }
}

