/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerOperationClient
implements ScmClient {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerOperationClient.class);
    private final long containerSizeB;
    private final HddsProtos.ReplicationFactor replicationFactor;
    private final HddsProtos.ReplicationType replicationType;
    private final StorageContainerLocationProtocol storageContainerLocationClient;
    private final XceiverClientManager xceiverClientManager;

    public ContainerOperationClient(Configuration conf) throws IOException {
        this.storageContainerLocationClient = ContainerOperationClient.newContainerRpcClient(conf);
        this.xceiverClientManager = this.newXCeiverClientManager(conf);
        this.containerSizeB = (int)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        boolean useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        if (useRatis) {
            this.replicationFactor = HddsProtos.ReplicationFactor.THREE;
            this.replicationType = HddsProtos.ReplicationType.RATIS;
        } else {
            this.replicationFactor = HddsProtos.ReplicationFactor.ONE;
            this.replicationType = HddsProtos.ReplicationType.STAND_ALONE;
        }
    }

    private XceiverClientManager newXCeiverClientManager(Configuration conf) throws IOException {
        XceiverClientManager manager;
        if (OzoneSecurityUtil.isSecurityEnabled(conf)) {
            SecurityConfig securityConfig = new SecurityConfig(conf);
            SCMSecurityProtocolClientSideTranslatorPB scmSecurityProtocolClient = HddsServerUtil.getScmSecurityClient((OzoneConfiguration)securityConfig.getConfiguration());
            String caCertificate = scmSecurityProtocolClient.getCACertificate();
            manager = new XceiverClientManager(conf, OzoneConfiguration.of(conf).getObject(XceiverClientManager.ScmClientConfig.class), caCertificate);
        } else {
            manager = new XceiverClientManager(conf);
        }
        return manager;
    }

    public static StorageContainerLocationProtocol newContainerRpcClient(Configuration conf) throws IOException {
        Class<StorageContainerLocationProtocolPB> protocol = StorageContainerLocationProtocolPB.class;
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        long version = RPC.getProtocolVersion(protocol);
        InetSocketAddress scmAddress = HddsUtils.getScmAddressForClients(conf);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        SocketFactory socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        int rpcTimeOut = Client.getRpcTimeout((Configuration)conf);
        StorageContainerLocationProtocolPB rpcProxy = (StorageContainerLocationProtocolPB)RPC.getProxy(protocol, (long)version, (InetSocketAddress)scmAddress, (UserGroupInformation)user, (Configuration)conf, (SocketFactory)socketFactory, (int)rpcTimeOut);
        StorageContainerLocationProtocolClientSideTranslatorPB client = new StorageContainerLocationProtocolClientSideTranslatorPB(rpcProxy);
        return TracingUtil.createProxy(client, StorageContainerLocationProtocol.class, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerWithPipeline createContainer(String owner) throws IOException {
        XceiverClientSpi client = null;
        try {
            ContainerWithPipeline containerWithPipeline = this.storageContainerLocationClient.allocateContainer(this.replicationType, this.replicationFactor, owner);
            Pipeline pipeline = containerWithPipeline.getPipeline();
            client = this.xceiverClientManager.acquireClient(pipeline);
            Preconditions.checkState(pipeline.isOpen(), "Unexpected state=%s for pipeline=%s, expected state=%s", (Object)pipeline.getPipelineState(), (Object)pipeline.getId(), (Object)Pipeline.PipelineState.OPEN);
            this.createContainer(client, containerWithPipeline.getContainerInfo().getContainerID());
            ContainerWithPipeline containerWithPipeline2 = containerWithPipeline;
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
            return containerWithPipeline2;
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
            throw throwable;
        }
    }

    public void createContainer(XceiverClientSpi client, long containerId) throws IOException {
        ContainerProtocolCalls.createContainer(client, containerId, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container " + containerId + " machines:" + client.getPipeline().getNodes());
        }
    }

    private void createPipeline(XceiverClientSpi client, Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull(pipeline.getId(), "Pipeline name cannot be null when client create flag is set.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pipeline creation successful. Pipeline: {}", (Object)pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerWithPipeline createContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        XceiverClientSpi client = null;
        try {
            ContainerWithPipeline containerWithPipeline = this.storageContainerLocationClient.allocateContainer(type, factor, owner);
            Pipeline pipeline = containerWithPipeline.getPipeline();
            client = this.xceiverClientManager.acquireClient(pipeline);
            client = this.xceiverClientManager.acquireClient(pipeline);
            this.createContainer(client, containerWithPipeline.getContainerInfo().getContainerID());
            ContainerWithPipeline containerWithPipeline2 = containerWithPipeline;
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
            return containerWithPipeline2;
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
            throw throwable;
        }
    }

    @Override
    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState nodeStatuses, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        return this.storageContainerLocationClient.queryNode(nodeStatuses, queryScope, poolName);
    }

    @Override
    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return this.storageContainerLocationClient.createReplicationPipeline(type, factor, nodePool);
    }

    @Override
    public List<Pipeline> listPipelines() throws IOException {
        return this.storageContainerLocationClient.listPipelines();
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.storageContainerLocationClient.getPipeline(pipelineID);
    }

    @Override
    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.activatePipeline(pipelineID);
    }

    @Override
    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.deactivatePipeline(pipelineID);
    }

    @Override
    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.closePipeline(pipelineID);
    }

    @Override
    public void close() {
        try {
            this.xceiverClientManager.close();
        }
        catch (Exception ex) {
            LOG.error("Can't close " + this.getClass().getSimpleName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteContainer(long containerId, Pipeline pipeline, boolean force) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClient(pipeline);
            ContainerProtocolCalls.deleteContainer(client, containerId, force, null);
            this.storageContainerLocationClient.deleteContainer(containerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted container {}, machines: {} ", (Object)containerId, pipeline.getNodes());
            }
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
        }
    }

    @Override
    public void deleteContainer(long containerID, boolean force) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        this.deleteContainer(containerID, info.getPipeline(), force);
    }

    @Override
    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerProtos.ContainerDataProto readContainer(long containerID, Pipeline pipeline) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClient(pipeline);
            ContainerProtos.ReadContainerResponseProto response = ContainerProtocolCalls.readContainer(client, containerID, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read container {}, machines: {} ", (Object)containerID, pipeline.getNodes());
            }
            ContainerProtos.ContainerDataProto containerDataProto = response.getContainerData();
            return containerDataProto;
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
        }
    }

    @Override
    public ContainerProtos.ContainerDataProto readContainer(long containerID) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        return this.readContainer(containerID, info.getPipeline());
    }

    @Override
    public ContainerInfo getContainer(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainer(containerId);
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainerWithPipeline(containerId);
    }

    @Override
    public void closeContainer(long containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Close container {}", (Object)containerId);
        }
        this.storageContainerLocationClient.closeContainer(containerId);
    }

    @Override
    public long getContainerSize(long containerID) throws IOException {
        return this.containerSizeB;
    }

    @Override
    public boolean inSafeMode() throws IOException {
        return this.storageContainerLocationClient.inSafeMode();
    }

    @Override
    public boolean forceExitSafeMode() throws IOException {
        return this.storageContainerLocationClient.forceExitSafeMode();
    }

    @Override
    public void startReplicationManager() throws IOException {
        this.storageContainerLocationClient.startReplicationManager();
    }

    @Override
    public void stopReplicationManager() throws IOException {
        this.storageContainerLocationClient.stopReplicationManager();
    }

    @Override
    public boolean getReplicationManagerStatus() throws IOException {
        return this.storageContainerLocationClient.getReplicationManagerStatus();
    }
}

