/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public abstract class XceiverClientSpi
implements Closeable {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private boolean isEvicted = false;

    XceiverClientSpi() {
    }

    void incrementReference() {
        this.referenceCount.incrementAndGet();
    }

    void decrementReference() {
        this.referenceCount.decrementAndGet();
        this.cleanup();
    }

    void setEvicted() {
        this.isEvicted = true;
        this.cleanup();
    }

    private void cleanup() {
        if (this.referenceCount.get() == 0 && this.isEvicted) {
            this.close();
        }
    }

    @VisibleForTesting
    public int getRefcount() {
        return this.referenceCount.get();
    }

    public abstract void connect() throws Exception;

    public abstract void connect(String var1) throws Exception;

    @Override
    public abstract void close();

    public abstract Pipeline getPipeline();

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandAsync(request);
            return reply.getResponse().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.getIOExceptionForSendCommand(request, e);
        }
        catch (ExecutionException e) {
            throw this.getIOExceptionForSendCommand(request, e);
        }
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandAsync(request);
            ContainerProtos.ContainerCommandResponseProto responseProto = reply.getResponse().get();
            for (CheckedBiFunction function : validators) {
                function.apply(request, responseProto);
            }
            return responseProto;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.getIOExceptionForSendCommand(request, e);
        }
        catch (ExecutionException e) {
            throw this.getIOExceptionForSendCommand(request, e);
        }
    }

    private IOException getIOExceptionForSendCommand(ContainerProtos.ContainerCommandRequestProto request, Exception e) {
        return new IOException("Failed to execute command " + request, e);
    }

    public abstract XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto var1) throws IOException, ExecutionException, InterruptedException;

    public abstract HddsProtos.ReplicationType getPipelineType();

    public abstract XceiverClientReply watchForCommit(long var1) throws InterruptedException, ExecutionException, TimeoutException, IOException;

    public abstract long getReplicatedMinCommitIndex();
}

