/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.GlobalTracer;
import org.apache.hadoop.util.Time;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverClientRatis
extends XceiverClientSpi {
    public static final Logger LOG = LoggerFactory.getLogger(XceiverClientRatis.class);
    private final Pipeline pipeline;
    private final RpcType rpcType;
    private final AtomicReference<RaftClient> client = new AtomicReference();
    private final RetryPolicy retryPolicy;
    private final GrpcTlsConfig tlsConfig;
    private final Configuration ozoneConfiguration;
    private final ConcurrentHashMap<UUID, Long> commitInfoMap;
    private XceiverClientMetrics metrics;

    public static XceiverClientRatis newXceiverClientRatis(Pipeline pipeline, Configuration ozoneConf) {
        return XceiverClientRatis.newXceiverClientRatis(pipeline, ozoneConf, null);
    }

    public static XceiverClientRatis newXceiverClientRatis(Pipeline pipeline, Configuration ozoneConf, X509Certificate caCert) {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy(ozoneConf);
        GrpcTlsConfig tlsConfig = RatisHelper.createTlsClientConfig(new SecurityConfig(ozoneConf), caCert);
        return new XceiverClientRatis(pipeline, SupportedRpcType.valueOfIgnoreCase(rpcType), retryPolicy, tlsConfig, ozoneConf);
    }

    private XceiverClientRatis(Pipeline pipeline, RpcType rpcType, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, Configuration configuration) {
        this.pipeline = pipeline;
        this.rpcType = rpcType;
        this.retryPolicy = retryPolicy;
        this.commitInfoMap = new ConcurrentHashMap();
        this.tlsConfig = tlsConfig;
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
        this.ozoneConfiguration = configuration;
    }

    private void updateCommitInfosMap(Collection<RaftProtos.CommitInfoProto> commitInfoProtos) {
        if (this.commitInfoMap.isEmpty()) {
            commitInfoProtos.forEach(proto -> this.commitInfoMap.put(RatisHelper.toDatanodeId(proto.getServer()), proto.getCommitIndex()));
        } else {
            commitInfoProtos.forEach(proto -> this.commitInfoMap.computeIfPresent(RatisHelper.toDatanodeId(proto.getServer()), (address, index) -> {
                index = proto.getCommitIndex();
                return index;
            }));
        }
    }

    @Override
    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void connect() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to pipeline:{} datanode:{}", (Object)this.getPipeline().getId(), (Object)RatisHelper.toRaftPeerId(this.pipeline.getFirstNode()));
        }
        if (!this.client.compareAndSet(null, RatisHelper.newRaftClient(this.rpcType, this.getPipeline(), this.retryPolicy, this.tlsConfig, this.ozoneConfiguration))) {
            throw new IllegalStateException("Client is already connected.");
        }
    }

    @Override
    public void connect(String encodedToken) throws Exception {
        throw new UnsupportedOperationException("Block tokens are not implemented for Ratis clients.");
    }

    @Override
    public void close() {
        RaftClient c = this.client.getAndSet(null);
        if (c != null) {
            this.closeRaftClient(c);
        }
    }

    private void closeRaftClient(RaftClient raftClient) {
        try {
            raftClient.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RaftClient getClient() {
        return Objects.requireNonNull(this.client.get(), "client is null");
    }

    @VisibleForTesting
    public ConcurrentMap<UUID, Long> getCommitInfoMap() {
        return this.commitInfoMap;
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(ContainerProtos.ContainerCommandRequestProto request) {
        try (Scope scope = GlobalTracer.get().buildSpan("XceiverClientRatis." + request.getCmdType().name()).startActive(true);){
            ContainerCommandRequestMessage message = ContainerCommandRequestMessage.toMessage(request, TracingUtil.exportCurrentSpan());
            if (HddsUtils.isReadOnly(request)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendCommandAsync ReadOnly {}", (Object)message);
                }
                CompletableFuture<RaftClientReply> completableFuture = this.getClient().sendReadOnlyAsync(message);
                return completableFuture;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendCommandAsync {}", (Object)message);
            }
            CompletableFuture<RaftClientReply> completableFuture = this.getClient().sendAsync(message);
            return completableFuture;
        }
    }

    @Override
    public long getReplicatedMinCommitIndex() {
        OptionalLong minIndex = this.commitInfoMap.values().parallelStream().mapToLong(v -> v).min();
        return minIndex.isPresent() ? minIndex.getAsLong() : 0L;
    }

    private void addDatanodetoReply(UUID address, XceiverClientReply reply) {
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(address.toString());
        reply.addDatanode(builder.build());
    }

    @Override
    public XceiverClientReply watchForCommit(long index) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        long commitIndex = this.getReplicatedMinCommitIndex();
        XceiverClientReply clientReply = new XceiverClientReply(null);
        if (commitIndex >= index) {
            clientReply.setLogIndex(commitIndex);
            return clientReply;
        }
        try {
            CompletableFuture<RaftClientReply> replyFuture = this.getClient().sendWatchAsync(index, RaftProtos.ReplicationLevel.ALL_COMMITTED);
            replyFuture.get();
        }
        catch (Exception e) {
            Throwable t = HddsClientUtils.checkForException(e);
            LOG.warn("3 way commit failed on pipeline {}", (Object)this.pipeline, (Object)e);
            if (t instanceof GroupMismatchException) {
                throw e;
            }
            RaftClientReply reply = this.getClient().sendWatchAsync(index, RaftProtos.ReplicationLevel.MAJORITY_COMMITTED).get();
            List commitInfoProtoList = reply.getCommitInfos().stream().filter(i -> i.getCommitIndex() < index).collect(Collectors.toList());
            commitInfoProtoList.parallelStream().forEach(proto -> {
                UUID address = RatisHelper.toDatanodeId(proto.getServer());
                this.addDatanodetoReply(address, clientReply);
                this.commitInfoMap.remove(address);
                LOG.info("Could not commit index {} on pipeline {} to all the nodes. Server {} has failed. Committed by majority.", new Object[]{index, this.pipeline, address});
            });
        }
        clientReply.setLogIndex(index);
        return clientReply;
    }

    @Override
    public XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) {
        XceiverClientReply asyncReply = new XceiverClientReply(null);
        long requestTime = Time.monotonicNowNanos();
        CompletableFuture<RaftClientReply> raftClientReply = this.sendRequestAsync(request);
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        CompletionStage containerCommandResponse = ((CompletableFuture)raftClientReply.whenComplete((reply, e) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received reply {} for request: cmdType={} containerID={} pipelineID={} traceID={} exception: {}", new Object[]{reply, request.getCmdType(), request.getContainerID(), request.getPipelineID(), request.getTraceID(), e});
            }
            this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
            this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
        })).thenApply(reply -> {
            try {
                if (!reply.isSuccess()) {
                    RaftException exception = reply.getException();
                    Preconditions.checkNotNull(exception, "Raft reply failure but no exception propagated.");
                    throw new CompletionException(exception);
                }
                ContainerProtos.ContainerCommandResponseProto response = ContainerProtos.ContainerCommandResponseProto.parseFrom(reply.getMessage().getContent());
                UUID serverId = RatisHelper.toDatanodeId(reply.getReplierId());
                if (response.getResult() == ContainerProtos.Result.SUCCESS) {
                    this.updateCommitInfosMap(reply.getCommitInfos());
                }
                asyncReply.setLogIndex(reply.getLogIndex());
                this.addDatanodetoReply(serverId, asyncReply);
                return response;
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompletionException(e);
            }
        });
        asyncReply.setResponse((CompletableFuture<ContainerProtos.ContainerCommandResponseProto>)containerCommandResponse);
        return asyncReply;
    }
}

