/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.XceiverClientGrpc;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientRatis;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.Cache;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.RemovalListener;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.RemovalNotification;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverClientManager.class);
    private final Configuration conf;
    private final Cache<String, XceiverClientSpi> clientCache;
    private X509Certificate caCert;
    private static XceiverClientMetrics metrics;
    private boolean isSecurityEnabled;
    private final boolean topologyAwareRead;

    public XceiverClientManager(Configuration conf) throws IOException {
        this(conf, OzoneConfiguration.of(conf).getObject(ScmClientConfig.class), null);
    }

    public XceiverClientManager(Configuration conf, ScmClientConfig clientConf, String caCertPem) throws IOException {
        Preconditions.checkNotNull(clientConf);
        Preconditions.checkNotNull(conf);
        long staleThresholdMs = clientConf.getStaleThreshold(TimeUnit.MILLISECONDS);
        this.conf = conf;
        this.isSecurityEnabled = OzoneSecurityUtil.isSecurityEnabled(conf);
        if (this.isSecurityEnabled) {
            Preconditions.checkNotNull(caCertPem);
            try {
                this.caCert = CertificateCodec.getX509Cert(caCertPem);
            }
            catch (CertificateException ex) {
                throw new SCMSecurityException("Error: Fail to get SCM CA certificate", ex);
            }
        }
        this.clientCache = CacheBuilder.newBuilder().expireAfterAccess(staleThresholdMs, TimeUnit.MILLISECONDS).maximumSize(clientConf.getMaxSize()).removalListener(new RemovalListener<String, XceiverClientSpi>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoval(RemovalNotification<String, XceiverClientSpi> removalNotification) {
                Cache cache = XceiverClientManager.this.clientCache;
                synchronized (cache) {
                    XceiverClientSpi info = (XceiverClientSpi)removalNotification.getValue();
                    info.setEvicted();
                }
            }
        }).build();
        this.topologyAwareRead = conf.getBoolean("ozone.network.topology.aware.read", false);
    }

    @VisibleForTesting
    public Cache<String, XceiverClientSpi> getClientCache() {
        return this.clientCache;
    }

    public XceiverClientSpi acquireClient(Pipeline pipeline) throws IOException {
        return this.acquireClient(pipeline, false);
    }

    public XceiverClientSpi acquireClientForReadData(Pipeline pipeline) throws IOException {
        return this.acquireClient(pipeline, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XceiverClientSpi acquireClient(Pipeline pipeline, boolean read) throws IOException {
        Preconditions.checkNotNull(pipeline);
        Preconditions.checkArgument(pipeline.getNodes() != null);
        Preconditions.checkArgument(!pipeline.getNodes().isEmpty());
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            XceiverClientSpi info = this.getClient(pipeline, read);
            info.incrementReference();
            return info;
        }
    }

    public void releaseClient(XceiverClientSpi client, boolean invalidateClient) {
        this.releaseClient(client, invalidateClient, false);
    }

    public void releaseClientForReadData(XceiverClientSpi client, boolean invalidateClient) {
        this.releaseClient(client, invalidateClient, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseClient(XceiverClientSpi client, boolean invalidateClient, boolean read) {
        Preconditions.checkNotNull(client);
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            Pipeline pipeline;
            String key;
            XceiverClientSpi cachedClient;
            client.decrementReference();
            if (invalidateClient && (cachedClient = this.clientCache.getIfPresent(key = this.getPipelineCacheKey(pipeline = client.getPipeline(), read))) == client) {
                this.clientCache.invalidate(key);
            }
        }
    }

    private XceiverClientSpi getClient(final Pipeline pipeline, boolean forRead) throws IOException {
        final HddsProtos.ReplicationType type = pipeline.getType();
        try {
            String key = this.getPipelineCacheKey(pipeline, forRead);
            key = this.isSecurityEnabled ? key + UserGroupInformation.getCurrentUser().getShortUserName() : key;
            return this.clientCache.get(key, new Callable<XceiverClientSpi>(){

                @Override
                public XceiverClientSpi call() throws Exception {
                    XceiverClientSpi client = null;
                    switch (type) {
                        case RATIS: {
                            client = XceiverClientRatis.newXceiverClientRatis(pipeline, XceiverClientManager.this.conf, XceiverClientManager.this.caCert);
                            break;
                        }
                        case STAND_ALONE: {
                            client = new XceiverClientGrpc(pipeline, XceiverClientManager.this.conf, XceiverClientManager.this.caCert);
                            break;
                        }
                        default: {
                            throw new IOException("not implemented" + pipeline.getType());
                        }
                    }
                    ((XceiverClientSpi)client).connect();
                    return client;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Exception getting XceiverClient: " + e.toString(), e);
        }
    }

    private String getPipelineCacheKey(Pipeline pipeline, boolean forRead) {
        String key = pipeline.getId().getId().toString() + pipeline.getType();
        if (this.topologyAwareRead && forRead) {
            try {
                key = key + pipeline.getClosestNode().getHostName();
            }
            catch (IOException e) {
                LOG.error("Failed to get closest node to create pipeline cache key:" + e.getMessage());
            }
        }
        return key;
    }

    @Override
    public void close() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
        if (metrics != null) {
            metrics.unRegister();
        }
    }

    public Function<ByteBuffer, ByteString> byteBufferToByteStringConversion() {
        return ByteStringConversion.createByteBufferConversion(this.conf);
    }

    public static synchronized XceiverClientMetrics getXceiverClientMetrics() {
        if (metrics == null) {
            metrics = XceiverClientMetrics.create();
        }
        return metrics;
    }

    @ConfigGroup(prefix="scm.container.client")
    public static class ScmClientConfig {
        @Config(key="max.size", defaultValue="256", tags={ConfigTag.OZONE, ConfigTag.PERFORMANCE}, description="Controls the maximum number of connections that are cached via client connection pooling. If the number of connections exceed this count, then the oldest idle connection is evicted.")
        private int maxSize;
        @Config(key="idle.threshold", type=ConfigType.TIME, timeUnit=TimeUnit.MILLISECONDS, defaultValue="10s", tags={ConfigTag.OZONE, ConfigTag.PERFORMANCE}, description="In the standalone pipelines, the SCM clients use netty to  communicate with the container. It also uses connection pooling to reduce client side overheads. This allows a connection to stay idle for a while before the connection is closed.")
        private long staleThreshold;

        public long getStaleThreshold(TimeUnit unit) {
            return unit.convert(this.staleThreshold, TimeUnit.MILLISECONDS);
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        @VisibleForTesting
        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

