/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.GrpcClientInterceptor;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.GlobalTracer;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientGrpc
extends XceiverClientSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverClientGrpc.class);
    private final Pipeline pipeline;
    private final Configuration config;
    private Map<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub> asyncStubs;
    private XceiverClientMetrics metrics;
    private Map<UUID, ManagedChannel> channels;
    private final Semaphore semaphore;
    private boolean closed = false;
    private SecurityConfig secConfig;
    private final boolean topologyAwareRead;
    private X509Certificate caCert;
    private Map<ContainerProtos.DatanodeBlockID, DatanodeDetails> getBlockDNcache;

    public XceiverClientGrpc(Pipeline pipeline, Configuration config, X509Certificate caCert) {
        Preconditions.checkNotNull(pipeline);
        Preconditions.checkNotNull(config);
        this.pipeline = pipeline;
        this.config = config;
        this.secConfig = new SecurityConfig(config);
        this.semaphore = new Semaphore(HddsClientUtils.getMaxOutstandingRequests(config));
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
        this.channels = new HashMap<UUID, ManagedChannel>();
        this.asyncStubs = new HashMap<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub>();
        this.topologyAwareRead = config.getBoolean("ozone.network.topology.aware.read", false);
        this.caCert = caCert;
        this.getBlockDNcache = new ConcurrentHashMap<ContainerProtos.DatanodeBlockID, DatanodeDetails>();
    }

    public XceiverClientGrpc(Pipeline pipeline, Configuration config) {
        this(pipeline, config, null);
    }

    @Override
    public void connect() throws Exception {
        DatanodeDetails dn = this.topologyAwareRead ? this.pipeline.getClosestNode() : this.pipeline.getFirstNode();
        this.connectToDatanode(dn);
    }

    @Override
    public void connect(String encodedToken) throws Exception {
        DatanodeDetails dn = this.topologyAwareRead ? this.pipeline.getClosestNode() : this.pipeline.getFirstNode();
        this.connectToDatanode(dn);
    }

    private synchronized void connectToDatanode(DatanodeDetails dn) throws IOException {
        if (this.isConnected(dn)) {
            return;
        }
        int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
        if (port == 0) {
            port = this.config.getInt("dfs.container.ipc", 9859);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Nodes in pipeline : {}", this.pipeline.getNodes());
            LOG.debug("Connecting to server : {}", (Object)dn.getIpAddress());
        }
        NettyChannelBuilder channelBuilder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress(dn.getIpAddress(), port).usePlaintext().maxInboundMessageSize(0x2000000)).intercept(new ClientInterceptor[]{new GrpcClientInterceptor()});
        if (this.secConfig.isGrpcTlsEnabled()) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.caCert != null) {
                sslContextBuilder.trustManager(this.caCert);
            }
            if (this.secConfig.useTestCert()) {
                channelBuilder.overrideAuthority("localhost");
            }
            channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
        } else {
            channelBuilder.usePlaintext();
        }
        ManagedChannel channel = channelBuilder.build();
        XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub asyncStub = XceiverClientProtocolServiceGrpc.newStub(channel);
        this.asyncStubs.put(dn.getUuid(), asyncStub);
        this.channels.put(dn.getUuid(), channel);
    }

    @VisibleForTesting
    public boolean isConnected(DatanodeDetails details) {
        return this.isConnected(this.channels.get(details.getUuid()));
    }

    private boolean isConnected(ManagedChannel channel) {
        return channel != null && !channel.isTerminated() && !channel.isShutdown();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        for (ManagedChannel channel : this.channels.values()) {
            channel.shutdownNow();
            try {
                channel.awaitTermination(60L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        try {
            return this.sendCommandWithTraceIDAndRetry(request, null).getResponse().get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to execute command " + request, e);
        }
        catch (InterruptedException e) {
            LOG.error("Command execution was interrupted.");
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException("Command " + request + " was interrupted.").initCause(e);
        }
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandWithTraceIDAndRetry(request, validators);
            return reply.getResponse().get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to execute command " + request, e);
        }
        catch (InterruptedException e) {
            LOG.error("Command execution was interrupted.");
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException("Command " + request + " was interrupted.").initCause(e);
        }
    }

    private XceiverClientReply sendCommandWithTraceIDAndRetry(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        try (Scope scope = GlobalTracer.get().buildSpan("XceiverClientGrpc." + request.getCmdType().name()).startActive(true);){
            ContainerProtos.ContainerCommandRequestProto finalPayload = ContainerProtos.ContainerCommandRequestProto.newBuilder(request).setTraceID(TracingUtil.exportCurrentSpan()).build();
            XceiverClientReply xceiverClientReply = this.sendCommandWithRetry(finalPayload, validators);
            return xceiverClientReply;
        }
    }

    private XceiverClientReply sendCommandWithRetry(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        ContainerProtos.ContainerCommandResponseProto responseProto = null;
        IOException ioException = null;
        XceiverClientReply reply = new XceiverClientReply(null);
        List<DatanodeDetails> datanodeList = null;
        ContainerProtos.DatanodeBlockID blockID = null;
        if (request.getCmdType() == ContainerProtos.Type.ReadChunk) {
            blockID = request.getReadChunk().getBlockID();
        } else if (request.getCmdType() == ContainerProtos.Type.GetSmallFile) {
            blockID = request.getGetSmallFile().getBlock().getBlockID();
        }
        if (blockID != null) {
            DatanodeDetails cachedDN = this.getBlockDNcache.get(blockID);
            if (cachedDN != null) {
                datanodeList = this.pipeline.getNodes();
                int getBlockDNCacheIndex = datanodeList.indexOf(cachedDN);
                if (getBlockDNCacheIndex > 0) {
                    Collections.swap(datanodeList, 0, getBlockDNCacheIndex);
                }
            } else if (this.topologyAwareRead) {
                datanodeList = this.pipeline.getNodesInOrder();
            }
        }
        if (datanodeList == null) {
            datanodeList = this.pipeline.getNodes();
            Collections.shuffle(datanodeList);
        }
        for (DatanodeDetails dn : datanodeList) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing command {} on datanode {}", (Object)request, (Object)dn);
                }
                reply.addDatanode(dn);
                responseProto = this.sendCommandAsync(request, dn).getResponse().get();
                if (validators != null && !validators.isEmpty()) {
                    for (CheckedBiFunction validator : validators) {
                        validator.apply(request, responseProto);
                    }
                }
                if (request.getCmdType() != ContainerProtos.Type.GetBlock) break;
                ContainerProtos.DatanodeBlockID getBlockID = request.getGetBlock().getBlockID();
                this.getBlockDNcache.put(getBlockID, dn);
                break;
            }
            catch (IOException e) {
                ioException = e;
                responseProto = null;
            }
            catch (ExecutionException e) {
                LOG.debug("Failed to execute command {} on datanode {}", new Object[]{request, dn.getUuid(), e});
                if (Status.fromThrowable(e.getCause()).getCode() == Status.UNAUTHENTICATED.getCode()) {
                    throw new SCMSecurityException("Failed to authenticate with GRPC XceiverServer with Ozone block token.");
                }
                ioException = new IOException(e);
                responseProto = null;
            }
            catch (InterruptedException e) {
                LOG.error("Command execution was interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
                responseProto = null;
            }
        }
        if (responseProto != null) {
            reply.setResponse(CompletableFuture.completedFuture(responseProto));
            return reply;
        }
        Preconditions.checkNotNull(ioException);
        LOG.error("Failed to execute command {} on the pipeline {}.", (Object)request, (Object)this.pipeline);
        throw ioException;
    }

    @Override
    public XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) throws IOException, ExecutionException, InterruptedException {
        try (Scope scope = GlobalTracer.get().buildSpan("XceiverClientGrpc." + request.getCmdType().name()).startActive(true);){
            ContainerProtos.ContainerCommandRequestProto finalPayload = ContainerProtos.ContainerCommandRequestProto.newBuilder(request).setTraceID(TracingUtil.exportCurrentSpan()).build();
            XceiverClientReply asyncReply = this.sendCommandAsync(finalPayload, this.pipeline.getFirstNode());
            if (!HddsUtils.isReadOnly(request)) {
                asyncReply.getResponse().get();
            }
            XceiverClientReply xceiverClientReply = asyncReply;
            return xceiverClientReply;
        }
    }

    private XceiverClientReply sendCommandAsync(final ContainerProtos.ContainerCommandRequestProto request, DatanodeDetails dn) throws IOException, InterruptedException {
        this.checkOpen(dn, request.getEncodedToken());
        UUID dnId = dn.getUuid();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send command {} to datanode {}", (Object)request.getCmdType(), (Object)dn.getNetworkFullPath());
        }
        final CompletableFuture<ContainerProtos.ContainerCommandResponseProto> replyFuture = new CompletableFuture<ContainerProtos.ContainerCommandResponseProto>();
        this.semaphore.acquire();
        final long requestTime = Time.monotonicNowNanos();
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        StreamObserver<ContainerProtos.ContainerCommandRequestProto> requestObserver = this.asyncStubs.get(dnId).send(new StreamObserver<ContainerProtos.ContainerCommandResponseProto>(){

            @Override
            public void onNext(ContainerProtos.ContainerCommandResponseProto value) {
                replyFuture.complete(value);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            @Override
            public void onError(Throwable t) {
                replyFuture.completeExceptionally(t);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            @Override
            public void onCompleted() {
                if (!replyFuture.isDone()) {
                    replyFuture.completeExceptionally(new IOException("Stream completed but no reply for request " + request));
                }
            }
        });
        requestObserver.onNext(request);
        requestObserver.onCompleted();
        return new XceiverClientReply(replyFuture);
    }

    private synchronized void checkOpen(DatanodeDetails dn, String encodedToken) throws IOException {
        if (this.closed) {
            throw new IOException("This channel is not connected.");
        }
        ManagedChannel channel = this.channels.get(dn.getUuid());
        if (!this.isConnected(channel)) {
            this.reconnect(dn, encodedToken);
        }
    }

    private void reconnect(DatanodeDetails dn, String encodedToken) throws IOException {
        ManagedChannel channel;
        try {
            this.connectToDatanode(dn);
            channel = this.channels.get(dn.getUuid());
        }
        catch (Exception e) {
            throw new IOException("Error while connecting", e);
        }
        if (channel == null || !this.isConnected(channel)) {
            throw new IOException("This channel is not connected.");
        }
    }

    @Override
    public XceiverClientReply watchForCommit(long index) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        return null;
    }

    @Override
    public long getReplicatedMinCommitIndex() {
        return 0L;
    }

    @Override
    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }
}

