/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientCall;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ForwardingClientCall;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;

public class ClientCredentialInterceptor
implements ClientInterceptor {
    private final String user;
    private final String token;

    public ClientCredentialInterceptor(String user, String token) {
        this.user = user;
        this.token = token;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (ClientCredentialInterceptor.this.token != null) {
                    headers.put(OzoneConsts.OBT_METADATA_KEY, ClientCredentialInterceptor.this.token);
                }
                if (ClientCredentialInterceptor.this.user != null) {
                    headers.put(OzoneConsts.USER_METADATA_KEY, ClientCredentialInterceptor.this.user);
                }
                super.start(responseListener, headers);
            }
        };
    }
}

