/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;

public final class ByteStringConversion {
    private ByteStringConversion() {
    }

    public static Function<ByteBuffer, ByteString> createByteBufferConversion(Configuration config) {
        boolean unsafeEnabled;
        boolean bl = unsafeEnabled = config != null && config.getBoolean("ozone.UnsafeByteOperations.enabled", true);
        if (unsafeEnabled) {
            return UnsafeByteOperations::unsafeWrap;
        }
        return ByteStringConversion::safeWrap;
    }

    public static ByteString safeWrap(ByteBuffer buffer) {
        ByteString retval = ByteString.copyFrom(buffer);
        buffer.flip();
        return retval;
    }
}

