/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.ratis.conf.RaftProperties;
import org.junit.Assert;
import org.junit.Test;

public class TestRatisHelper {
    @Test
    public void testCreateRaftClientProperties() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.set("hdds.ratis.raft.client.rpc.watch.request.timeout", "30s");
        ozoneConfiguration.set("hdds.ratis.raft.client.rpc.request.timeout", "30s");
        ozoneConfiguration.set("hdds.ratis.raft.server.rpc.watch.request.timeout", "30s");
        RaftProperties raftProperties = new RaftProperties();
        RatisHelper.createRaftClientProperties(ozoneConfiguration, raftProperties);
        Assert.assertEquals((Object)"30s", (Object)raftProperties.get("raft.client.rpc.watch.request.timeout"));
        Assert.assertEquals((Object)"30s", (Object)raftProperties.get("raft.client.rpc.request.timeout"));
        Assert.assertNull((Object)raftProperties.get("raft.server.rpc.watch.request.timeout"));
    }

    @Test
    public void testCreateRaftGrpcPropertiesForClient() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.set("hdds.ratis.raft.grpc.message.size.max", "30MB");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.flow.control.window", "1MB");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.tls.enabled", "true");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.tls.mutual_authn.enabled", "true");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.server.port", "100");
        RaftProperties raftProperties = new RaftProperties();
        RatisHelper.createRaftClientProperties(ozoneConfiguration, raftProperties);
        Assert.assertEquals((Object)"30MB", (Object)raftProperties.get("raft.grpc.message.size.max"));
        Assert.assertEquals((Object)"1MB", (Object)raftProperties.get("raft.grpc.flow.control.window"));
        Assert.assertNull((Object)raftProperties.get("raft.grpc.tls.set"));
        Assert.assertNull((Object)raftProperties.get("raft.grpc.tls.mutual_authn.enabled"));
        Assert.assertNull((Object)raftProperties.get("raft.grpc.server.port"));
    }

    @Test
    public void testCreateRaftGrpcPropertiesForServer() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.set("hdds.ratis.raft.grpc.message.size.max", "30MB");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.flow.control.window", "1MB");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.tls.enabled", "true");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.tls.mutual_authn.enabled", "true");
        ozoneConfiguration.set("hdds.ratis.raft.grpc.server.port", "100");
        RaftProperties raftProperties = new RaftProperties();
        RatisHelper.createRaftServerProperties(ozoneConfiguration, raftProperties);
        Assert.assertEquals((Object)"30MB", (Object)raftProperties.get("raft.grpc.message.size.max"));
        Assert.assertEquals((Object)"1MB", (Object)raftProperties.get("raft.grpc.flow.control.window"));
        Assert.assertEquals((Object)"true", (Object)raftProperties.get("raft.grpc.tls.enabled"));
        Assert.assertEquals((Object)"true", (Object)raftProperties.get("raft.grpc.tls.mutual_authn.enabled"));
        Assert.assertEquals((Object)"100", (Object)raftProperties.get("raft.grpc.server.port"));
    }

    @Test
    public void testCreateRaftServerProperties() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.set("hdds.ratis.raft.server.rpc.watch.request.timeout", "30s");
        ozoneConfiguration.set("hdds.ratis.raft.server.rpc.request.timeout", "30s");
        ozoneConfiguration.set("hdds.ratis.raft.client.rpc.request.timeout", "30s");
        RaftProperties raftProperties = new RaftProperties();
        RatisHelper.createRaftServerProperties(ozoneConfiguration, raftProperties);
        Assert.assertEquals((Object)"30s", (Object)raftProperties.get("raft.server.rpc.watch.request.timeout"));
        Assert.assertEquals((Object)"30s", (Object)raftProperties.get("raft.server.rpc.request.timeout"));
        Assert.assertNull((Object)raftProperties.get("raft.client.rpc.request.timeout"));
    }
}

