/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerCommandRequestMessage {
    static final Random RANDOM = new Random();

    static ByteString newData(int length) {
        ByteString.Output out = ByteString.newOutput();
        for (int i = 0; i < length; ++i) {
            out.write(RANDOM.nextInt());
        }
        return out.toByteString();
    }

    static ChecksumData checksum(ByteString data) {
        try {
            return new Checksum().computeChecksum(data.asReadOnlyByteBuffer());
        }
        catch (OzoneChecksumException e) {
            throw new IllegalStateException(e);
        }
    }

    static ContainerProtos.ContainerCommandRequestProto newPutSmallFile(BlockID blockID, ByteString data) {
        ContainerProtos.BlockData.Builder blockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.PutBlockRequestProto.Builder putBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(blockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen(data.size()).addMetadata(keyValue).setChecksumData(TestContainerCommandRequestMessage.checksum(data).getProtoBufMessage()).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(putBlockRequest).setData(data).build();
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(UUID.randomUUID().toString()).setPutSmallFile(putSmallFileRequest).build();
    }

    static ContainerProtos.ContainerCommandRequestProto newWriteChunk(BlockID blockID, ByteString data) {
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk_" + 1).setOffset(0L).setLen(data.size()).setChecksumData(TestContainerCommandRequestMessage.checksum(data).getProtoBufMessage()).build();
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setData(data);
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(UUID.randomUUID().toString()).setWriteChunk(writeChunkRequest).build();
    }

    @Test
    public void testPutSmallFile() throws Exception {
        TestContainerCommandRequestMessage.runTest(TestContainerCommandRequestMessage::newPutSmallFile);
    }

    @Test
    public void testWriteChunk() throws Exception {
        TestContainerCommandRequestMessage.runTest(TestContainerCommandRequestMessage::newWriteChunk);
    }

    static void runTest(BiFunction<BlockID, ByteString, ContainerProtos.ContainerCommandRequestProto> method) throws Exception {
        int i;
        for (i = 0; i < 2; ++i) {
            TestContainerCommandRequestMessage.runTest(i, method);
        }
        i = 2;
        while (i < 1024) {
            TestContainerCommandRequestMessage.runTest(i + 1 + RANDOM.nextInt(i - 1), method);
            TestContainerCommandRequestMessage.runTest(i <<= 1, method);
        }
    }

    static void runTest(int length, BiFunction<BlockID, ByteString, ContainerProtos.ContainerCommandRequestProto> method) throws Exception {
        System.out.println("length=" + length);
        BlockID blockID = new BlockID(RANDOM.nextLong(), RANDOM.nextLong());
        ByteString data = TestContainerCommandRequestMessage.newData(length);
        ContainerProtos.ContainerCommandRequestProto original = method.apply(blockID, data);
        ContainerCommandRequestMessage message = ContainerCommandRequestMessage.toMessage(original, null);
        ContainerProtos.ContainerCommandRequestProto computed = ContainerCommandRequestMessage.toProto(message.getContent(), null);
        Assert.assertEquals((Object)original, (Object)computed);
    }
}

