/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RatisHelper {
    public static final Logger LOG = LoggerFactory.getLogger(RatisHelper.class);
    public static final String HDDS_DATANODE_RATIS_PREFIX_KEY = "hdds.ratis.";
    public static final String HDDS_DATANODE_RATIS_SERVER_PREFIX_KEY = "hdds.ratis.raft.server";
    public static final String HDDS_DATANODE_RATIS_CLIENT_PREFIX_KEY = "hdds.ratis.raft.client";
    public static final String HDDS_DATANODE_RATIS_GRPC_PREFIX_KEY = "hdds.ratis.raft.grpc";
    public static final RaftGroupId DUMMY_GROUP_ID = RaftGroupId.valueOf(ByteString.copyFromUtf8("AOzoneRatisGroup"));
    public static final RaftGroup EMPTY_GROUP = RaftGroup.valueOf(DUMMY_GROUP_ID, Collections.emptyList());

    public static String toRaftPeerIdString(DatanodeDetails id) {
        return id.getUuidString();
    }

    public static UUID toDatanodeId(String peerIdString) {
        return UUID.fromString(peerIdString);
    }

    public static UUID toDatanodeId(RaftPeerId peerId) {
        return RatisHelper.toDatanodeId(peerId.toString());
    }

    public static UUID toDatanodeId(RaftProtos.RaftPeerProto peerId) {
        return RatisHelper.toDatanodeId(RaftPeerId.valueOf(peerId.getId()));
    }

    public static String toRaftPeerAddressString(DatanodeDetails id) {
        return id.getIpAddress() + ":" + id.getPort(DatanodeDetails.Port.Name.RATIS).getValue();
    }

    public static RaftPeerId toRaftPeerId(DatanodeDetails id) {
        return RaftPeerId.valueOf(RatisHelper.toRaftPeerIdString(id));
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id) {
        return new RaftPeer(RatisHelper.toRaftPeerId(id), RatisHelper.toRaftPeerAddressString(id));
    }

    public static List<RaftPeer> toRaftPeers(Pipeline pipeline) {
        return RatisHelper.toRaftPeers(pipeline.getNodes());
    }

    public static <E extends DatanodeDetails> List<RaftPeer> toRaftPeers(List<E> datanodes) {
        return datanodes.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
    }

    public static RaftGroup emptyRaftGroup() {
        return EMPTY_GROUP;
    }

    public static RaftGroup newRaftGroup(Collection<RaftPeer> peers) {
        return peers.isEmpty() ? RatisHelper.emptyRaftGroup() : RaftGroup.valueOf(DUMMY_GROUP_ID, peers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, Collection<DatanodeDetails> peers) {
        List<RaftPeer> newPeers = peers.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
        return peers.isEmpty() ? RaftGroup.valueOf(groupId, Collections.emptyList()) : RaftGroup.valueOf(groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(Pipeline pipeline) {
        return RaftGroup.valueOf(RaftGroupId.valueOf(pipeline.getId().getId()), RatisHelper.toRaftPeers(pipeline));
    }

    public static RaftClient newRaftClient(RpcType rpcType, Pipeline pipeline, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, Configuration ozoneConfiguration) throws IOException {
        return RatisHelper.newRaftClient(rpcType, RatisHelper.toRaftPeerId(pipeline.getLeaderNode()), RatisHelper.newRaftGroup(RaftGroupId.valueOf(pipeline.getId().getId()), pipeline.getNodes()), retryPolicy, tlsConfig, ozoneConfiguration);
    }

    public static RpcType getRpcType(Configuration conf) {
        return SupportedRpcType.valueOfIgnoreCase(conf.get("dfs.container.ratis.rpc.type", "GRPC"));
    }

    public static RaftClient newRaftClient(RaftPeer leader, Configuration conf) {
        return RatisHelper.newRaftClient(RatisHelper.getRpcType(conf), leader, RatisHelper.createRetryPolicy(conf), conf);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, Configuration configuration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, tlsConfig, configuration);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, Configuration ozoneConfiguration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, null, ozoneConfiguration);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeerId leader, RaftGroup group, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, Configuration ozoneConfiguration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, leader, group});
        }
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType(properties, rpcType);
        RatisHelper.createRaftClientProperties(ozoneConfiguration, properties);
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leader).setProperties(properties).setRetryPolicy(retryPolicy);
        if (tlsConfig != null && rpcType == SupportedRpcType.GRPC) {
            builder.setParameters(GrpcFactory.newRaftParameters(tlsConfig));
        }
        return builder.build();
    }

    public static void createRaftClientProperties(Configuration ozoneConf, RaftProperties raftProperties) {
        Map ratisClientConf = ozoneConf.getPropsWithPrefix(HDDS_DATANODE_RATIS_PREFIX_KEY);
        ratisClientConf.forEach((key, val) -> {
            if (!(key.startsWith("raft.server") || key.startsWith("raft.grpc.tls") || key.startsWith("raft.grpc.server"))) {
                raftProperties.set((String)key, (String)val);
            }
        });
    }

    public static void createRaftServerProperties(Configuration ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisServerConf = RatisHelper.getDatanodeRatisPrefixProps(ozoneConf);
        ratisServerConf.forEach((key, val) -> {
            if (!key.startsWith("raft.client")) {
                raftProperties.set((String)key, (String)val);
            }
        });
    }

    public static Map<String, String> getDatanodeRatisPrefixProps(Configuration configuration) {
        return configuration.getPropsWithPrefix(HDDS_DATANODE_RATIS_PREFIX_KEY);
    }

    public static GrpcTlsConfig createTlsClientConfig(SecurityConfig conf, X509Certificate caCert) {
        GrpcTlsConfig tlsConfig = null;
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            tlsConfig = new GrpcTlsConfig(null, null, caCert, false);
        }
        return tlsConfig;
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        int maxRetryCount = conf.getInt("dfs.ratis.client.request.max.retries", 180);
        long retryInterval = conf.getTimeDuration("dfs.ratis.client.request.retry.interval", (long)OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_RETRY_INTERVAL_DEFAULT.toIntExact(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        TimeDuration sleepDuration = TimeDuration.valueOf(retryInterval, TimeUnit.MILLISECONDS);
        RetryPolicies.RetryLimited retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(maxRetryCount, sleepDuration);
        return retryPolicy;
    }

    public static Long getMinReplicatedIndex(Collection<RaftProtos.CommitInfoProto> commitInfos) {
        return commitInfos.stream().map(RaftProtos.CommitInfoProto::getCommitIndex).min(Long::compareTo).orElse(null);
    }
}

