/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.JavaUtils;

public final class ContainerCommandRequestMessage
implements Message {
    private final ContainerProtos.ContainerCommandRequestProto header;
    private final ByteString data;
    private final Supplier<ByteString> contentSupplier = JavaUtils.memoize(this::buildContent);

    public static ContainerCommandRequestMessage toMessage(ContainerProtos.ContainerCommandRequestProto request, String traceId) {
        ContainerProtos.ContainerCommandRequestProto.Builder b = ContainerProtos.ContainerCommandRequestProto.newBuilder(request);
        if (traceId != null) {
            b.setTraceID(traceId);
        }
        ByteString data = ByteString.EMPTY;
        if (request.getCmdType() == ContainerProtos.Type.WriteChunk) {
            ContainerProtos.WriteChunkRequestProto w = request.getWriteChunk();
            data = w.getData();
            b.setWriteChunk(w.toBuilder().clearData());
        } else if (request.getCmdType() == ContainerProtos.Type.PutSmallFile) {
            ContainerProtos.PutSmallFileRequestProto p = request.getPutSmallFile();
            data = p.getData();
            b.setPutSmallFile(p.toBuilder().setData(ByteString.EMPTY));
        }
        return new ContainerCommandRequestMessage(b.build(), data);
    }

    public static ContainerProtos.ContainerCommandRequestProto toProto(ByteString bytes, RaftGroupId groupId) throws InvalidProtocolBufferException {
        int i = 4 + bytes.asReadOnlyByteBuffer().getInt();
        ContainerProtos.ContainerCommandRequestProto header = ContainerProtos.ContainerCommandRequestProto.parseFrom(bytes.substring(4, i));
        ContainerProtos.ContainerCommandRequestProto.Builder b = header.toBuilder();
        if (groupId != null) {
            b.setPipelineID(groupId.getUuid().toString());
        }
        ByteString data = bytes.substring(i);
        if (header.getCmdType() == ContainerProtos.Type.WriteChunk) {
            b.setWriteChunk(b.getWriteChunkBuilder().setData(data));
        } else if (header.getCmdType() == ContainerProtos.Type.PutSmallFile) {
            b.setPutSmallFile(b.getPutSmallFileBuilder().setData(data));
        }
        return b.build();
    }

    private ContainerCommandRequestMessage(ContainerProtos.ContainerCommandRequestProto header, ByteString data) {
        this.header = Objects.requireNonNull(header, "header == null");
        this.data = Objects.requireNonNull(data, "data == null");
    }

    private ByteString buildContent() {
        ByteString headerBytes = this.header.toByteString();
        return Checksum.int2ByteString(headerBytes.size()).concat(headerBytes).concat(this.data);
    }

    @Override
    public ByteString getContent() {
        return this.contentSupplier.get();
    }

    public String toString() {
        return this.header + ", data.size=" + this.data.size();
    }
}

