/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

public class SCMSecurityProtocolClientSideTranslatorPB
implements SCMSecurityProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final SCMSecurityProtocolPB rpcProxy;

    public SCMSecurityProtocolClientSideTranslatorPB(SCMSecurityProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    private SCMSecurityProtocolProtos.SCMSecurityResponse submitRequest(SCMSecurityProtocolProtos.Type type, Consumer<SCMSecurityProtocolProtos.SCMSecurityRequest.Builder> builderConsumer) throws IOException {
        SCMSecurityProtocolProtos.SCMSecurityResponse response;
        try {
            SCMSecurityProtocolProtos.SCMSecurityRequest.Builder builder = SCMSecurityProtocolProtos.SCMSecurityRequest.newBuilder().setCmdType(type).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            SCMSecurityProtocolProtos.SCMSecurityRequest wrapper = builder.build();
            response = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dataNodeDetails, String certSignReq) throws IOException {
        return this.getDataNodeCertificateChain(dataNodeDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        return this.getOMCertChain(omDetails, certSignReq).getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertChain(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request = SCMSecurityProtocolProtos.SCMGetOMCertRequestProto.newBuilder().setCSR(certSignReq).setOmDetails(omDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetOMCertificate, builder -> builder.setGetOMCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCertificate(String certSerialId) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request = SCMSecurityProtocolProtos.SCMGetCertificateRequestProto.newBuilder().setCertSerialId(certSerialId).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCertificate, builder -> builder.setGetCertificateRequest(request)).getGetCertResponseProto().getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificateChain(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request = SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto.newBuilder().setCSR(certSignReq).setDatanodeDetails(dnDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetDataNodeCertificate, builder -> builder.setGetDataNodeCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCACertificate, builder -> builder.setGetCACertificateRequest(protoIns)).getGetCertResponseProto().getX509Certificate();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

