/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;

public final class MockDatanodeDetails {
    public static DatanodeDetails randomDatanodeDetails() {
        return MockDatanodeDetails.createDatanodeDetails(UUID.randomUUID());
    }

    public static DatanodeDetails createDatanodeDetails(String hostname, String loc) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String ipAddress = ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256);
        return MockDatanodeDetails.createDatanodeDetails(UUID.randomUUID().toString(), hostname, ipAddress, loc);
    }

    public static DatanodeDetails createDatanodeDetails(UUID uuid) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String ipAddress = ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256) + "." + ((Random)random).nextInt(256);
        return MockDatanodeDetails.createDatanodeDetails(uuid.toString(), "localhost-" + ipAddress, ipAddress, null);
    }

    public static DatanodeDetails createDatanodeDetails(String uuid, String hostname, String ipAddress, String networkLocation) {
        return MockDatanodeDetails.createDatanodeDetails(uuid, hostname, ipAddress, networkLocation, 0);
    }

    public static DatanodeDetails createDatanodeDetails(String uuid, String hostname, String ipAddress, String networkLocation, int port) {
        DatanodeDetails.Port containerPort = DatanodeDetails.newPort(DatanodeDetails.Port.Name.STANDALONE, port);
        DatanodeDetails.Port ratisPort = DatanodeDetails.newPort(DatanodeDetails.Port.Name.RATIS, port);
        DatanodeDetails.Port restPort = DatanodeDetails.newPort(DatanodeDetails.Port.Name.REST, port);
        return DatanodeDetails.newBuilder().setUuid(uuid).setHostName(hostname).setIpAddress(ipAddress).addPort(containerPort).addPort(ratisPort).addPort(restPort).setNetworkLocation(networkLocation).build();
    }

    public static DatanodeDetails randomLocalDatanodeDetails() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            DatanodeDetails datanodeDetails = MockDatanodeDetails.createDatanodeDetails(UUID.randomUUID().toString(), socket.getInetAddress().getHostName(), socket.getInetAddress().getHostAddress(), null, socket.getLocalPort());
            return datanodeDetails;
        }
    }

    private MockDatanodeDetails() {
        throw new UnsupportedOperationException("no instances");
    }
}

