/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpaceUsageFactory {
    private GenericTestUtils.LogCapturer capturer;

    protected static <T extends SpaceUsageCheckFactory> T testCreateViaConfig(Class<T> factoryClass) {
        Configuration conf = TestSpaceUsageFactory.configFor(factoryClass);
        SpaceUsageCheckFactory factory = SpaceUsageCheckFactory.create(conf);
        Assertions.assertSame(factoryClass, factory.getClass());
        return (T)((SpaceUsageCheckFactory)factoryClass.cast(factory));
    }

    @Before
    public void setUp() {
        this.capturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SpaceUsageCheckFactory.class));
    }

    @Test
    public void configuresFactoryInstance() {
        SpyFactory factory = TestSpaceUsageFactory.testCreateViaConfig(SpyFactory.class);
        Assertions.assertNotNull((Object)factory.getConf());
    }

    @Test
    public void returnsDefaultFactoryForMissingNoArgs() {
        TestSpaceUsageFactory.testDefaultFactoryForBrokenImplementation(MissingNoArgsConstructor.class);
    }

    @Test
    public void returnsDefaultFactoryForPrivateConstructor() {
        TestSpaceUsageFactory.testDefaultFactoryForBrokenImplementation(PrivateConstructor.class);
    }

    @Test
    public void returnsDefaultFactoryForMissingConfig() {
        this.testDefaultFactoryForWrongConfig("");
    }

    @Test
    public void returnsDefaultFactoryForUnknownClass() {
        this.testDefaultFactoryForWrongConfig("no.such.class");
    }

    @Test
    public void returnsDefaultFactoryForClassThatDoesNotImplementInterface() {
        this.testDefaultFactoryForWrongConfig("java.lang.String");
    }

    private void assertNoLog() {
        Assertions.assertEquals((Object)"", (Object)this.capturer.getOutput());
    }

    private void assertLogged(String substring) {
        String output = this.capturer.getOutput();
        Assertions.assertTrue((boolean)output.contains(substring), () -> "Expected " + substring + " " + "in log output, but only got: " + output);
    }

    private static <T extends SpaceUsageCheckFactory> Configuration configFor(Class<T> factoryClass) {
        Configuration conf = new Configuration();
        conf.setClass(SpaceUsageCheckFactory.Conf.configKeyForClassName(), factoryClass, SpaceUsageCheckFactory.class);
        return conf;
    }

    private static void testDefaultFactoryForBrokenImplementation(Class<? extends SpaceUsageCheckFactory> brokenImplementationClass) {
        Configuration conf = TestSpaceUsageFactory.configFor(brokenImplementationClass);
        TestSpaceUsageFactory.assertCreatesDefaultImplementation(conf);
    }

    private void testDefaultFactoryForWrongConfig(String value) {
        Configuration conf = new Configuration();
        conf.set(SpaceUsageCheckFactory.Conf.configKeyForClassName(), value);
        TestSpaceUsageFactory.assertCreatesDefaultImplementation(conf);
        if (value == null || value.isEmpty()) {
            this.assertNoLog();
        } else {
            this.assertLogged(value);
        }
    }

    private static void assertCreatesDefaultImplementation(Configuration conf) {
        SpaceUsageCheckFactory factory = SpaceUsageCheckFactory.create(conf);
        Assertions.assertSame(SpaceUsageCheckFactory.defaultImplementation().getClass(), factory.getClass());
    }

    public static final class SpyFactory
    implements SpaceUsageCheckFactory {
        private Configuration conf;

        @Override
        public SpaceUsageCheckFactory setConfiguration(Configuration config) {
            this.conf = config;
            return this;
        }

        @Override
        public SpaceUsageCheckParams paramsFor(File dir) {
            throw new UnsupportedOperationException();
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    public static final class PrivateConstructor
    extends BrokenFactoryImpl {
        private PrivateConstructor() {
        }
    }

    public static final class MissingNoArgsConstructor
    extends BrokenFactoryImpl {
        public MissingNoArgsConstructor(String ignored) {
        }
    }

    protected static class BrokenFactoryImpl
    implements SpaceUsageCheckFactory {
        protected BrokenFactoryImpl() {
        }

        @Override
        public SpaceUsageCheckParams paramsFor(File dir) {
            throw new UnsupportedOperationException();
        }
    }
}

