/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.fs.DedicatedDiskSpaceUsage;
import org.apache.hadoop.hdds.fs.DedicatedDiskSpaceUsageFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.TestSpaceUsageFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestDedicatedDiskSpaceUsageFactory {
    @Test
    public void testCreateViaConfig() {
        TestSpaceUsageFactory.testCreateViaConfig(DedicatedDiskSpaceUsageFactory.class);
    }

    @Test
    public void testParams() {
        Configuration conf = new Configuration();
        conf.set(DedicatedDiskSpaceUsageFactory.Conf.configKeyForRefreshPeriod(), "2m");
        File dir = GenericTestUtils.getTestDir((String)this.getClass().getSimpleName());
        SpaceUsageCheckParams params = new DedicatedDiskSpaceUsageFactory().setConfiguration(conf).paramsFor(dir);
        Assertions.assertSame((Object)dir, (Object)params.getDir());
        Assertions.assertEquals((Object)Duration.ofMinutes(2L), (Object)params.getRefresh());
        Assertions.assertSame(DedicatedDiskSpaceUsage.class, params.getSource().getClass());
    }
}

