/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.fs.DedicatedDiskSpaceUsage;
import org.apache.hadoop.hdds.fs.TestDU;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDedicatedDiskSpaceUsage {
    private static final File DIR = GenericTestUtils.getTestDir((String)TestDedicatedDiskSpaceUsage.class.getSimpleName());
    private static final int FILE_SIZE = 1024;

    @Before
    public void setUp() {
        FileUtil.fullyDelete((File)DIR);
        Assert.assertTrue((boolean)DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DIR);
    }

    @Test
    public void testGetUsed() throws IOException {
        File file = new File(DIR, "data");
        TestDU.createFile(file, 1024);
        DedicatedDiskSpaceUsage subject = new DedicatedDiskSpaceUsage(DIR);
        Assert.assertTrue((subject.getUsedSpace() >= 1004L ? 1 : 0) != 0);
    }
}

