/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.fs.DU;
import org.apache.hadoop.hdds.fs.DUFactory;
import org.apache.hadoop.hdds.fs.SaveSpaceUsageToFile;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.TestSpaceUsageFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestDUFactory {
    @Test
    public void testCreateViaConfig() {
        TestSpaceUsageFactory.testCreateViaConfig(DUFactory.class);
    }

    @Test
    public void testParams() {
        Configuration conf = new Configuration();
        conf.set(DUFactory.Conf.configKeyForRefreshPeriod(), "1h");
        File dir = GenericTestUtils.getTestDir((String)this.getClass().getSimpleName());
        SpaceUsageCheckParams params = new DUFactory().setConfiguration(conf).paramsFor(dir);
        Assertions.assertSame((Object)dir, (Object)params.getDir());
        Assertions.assertEquals((Object)Duration.ofHours(1L), (Object)params.getRefresh());
        Assertions.assertSame(DU.class, params.getSource().getClass());
        Assertions.assertSame(SaveSpaceUsageToFile.class, params.getPersistence().getClass());
    }
}

