/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.hdds.fs.MockSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public final class MockSpaceUsageCheckParams {
    public static Builder newBuilder(File dir) {
        return new Builder(dir);
    }

    private MockSpaceUsageCheckParams() {
        throw new UnsupportedOperationException("no instances");
    }

    public static final class Builder {
        private final File dir;
        private SpaceUsageSource source = MockSpaceUsageSource.unlimited();
        private Duration refresh = Duration.ZERO;
        private SpaceUsagePersistence persistence = SpaceUsagePersistence.None.INSTANCE;

        private Builder(File dir) {
            this.dir = dir;
        }

        public Builder withSource(SpaceUsageSource newSource) {
            this.source = newSource;
            return this;
        }

        public Builder withRefresh(Duration newRefresh) {
            this.refresh = newRefresh;
            return this;
        }

        public Builder withPersistence(SpaceUsagePersistence newPersistence) {
            this.persistence = newPersistence;
            return this;
        }

        public SpaceUsageCheckParams build() {
            return new SpaceUsageCheckParams(this.dir, this.source, this.refresh, this.persistence);
        }
    }
}

