/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.hdds.fs.MockSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public final class MockSpaceUsageCheckFactory {
    public static final SpaceUsageCheckFactory NONE = new None();

    public static SpaceUsageCheckFactory of(SpaceUsageSource source, Duration refresh, SpaceUsagePersistence persistence) {
        return dir -> new SpaceUsageCheckParams(dir, source, refresh, persistence);
    }

    private MockSpaceUsageCheckFactory() {
        throw new UnsupportedOperationException("no instances");
    }

    public static class None
    implements SpaceUsageCheckFactory {
        @Override
        public SpaceUsageCheckParams paramsFor(File dir) {
            return new SpaceUsageCheckParams(dir, MockSpaceUsageSource.unlimited(), Duration.ZERO, SpaceUsagePersistence.None.INSTANCE);
        }
    }
}

