/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis.raft.client")
public class RatisClientConfig {
    @Config(key="async.outstanding-requests.max", defaultValue="32", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Controls the maximum number of outstanding async requests that can be handled by the Standalone as well as Ratis client.")
    private int maxOutstandingRequests;
    @Config(key="rpc.request.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client request (except for watch request). It should be set greater than leader election timeout in Ratis.")
    private long requestTimeOut = 60000L;
    @Config(key="rpc.watch.request.timeout", defaultValue="180s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client watch request. Timeout for the watch API in Ratis client to acknowledge a particular request getting replayed to all servers.")
    private long watchRequestTimeOut = 180000L;

    public int getMaxOutstandingRequests() {
        return this.maxOutstandingRequests;
    }

    public void setMaxOutstandingRequests(int maxOutstandingRequests) {
        this.maxOutstandingRequests = maxOutstandingRequests;
    }

    public long getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setRequestTimeOut(long requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public long getWatchRequestTimeOut() {
        return this.watchRequestTimeOut;
    }

    public void setWatchRequestTimeOut(long watchRequestTimeOut) {
        this.watchRequestTimeOut = watchRequestTimeOut;
    }
}

