/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigFileAppender {
    private Document document;
    private final DocumentBuilder builder;

    public ConfigFileAppender() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.builder = factory.newDocumentBuilder();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Can initialize new configuration", ex);
        }
    }

    public void init() {
        try {
            this.document = this.builder.newDocument();
            this.document.appendChild(this.document.createElement("configuration"));
        }
        catch (Exception ex) {
            throw new ConfigurationException("Can initialize new configuration", ex);
        }
    }

    public void load(InputStream stream) {
        try {
            this.document = this.builder.parse(stream);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Can't load existing configuration", ex);
        }
    }

    public void addConfig(String key, String defaultValue, String description, ConfigTag[] tags) {
        Element root = this.document.getDocumentElement();
        Element propertyElement = this.document.createElement("property");
        this.addXmlElement(propertyElement, "name", key);
        this.addXmlElement(propertyElement, "value", defaultValue);
        this.addXmlElement(propertyElement, "description", description);
        String tagsAsString = Arrays.stream(tags).map(Enum::name).collect(Collectors.joining(", "));
        this.addXmlElement(propertyElement, "tag", tagsAsString);
        root.appendChild(propertyElement);
    }

    private void addXmlElement(Element parentElement, String tagValue, String textValue) {
        Element element = this.document.createElement(tagValue);
        element.appendChild(this.document.createTextNode(textValue));
        parentElement.appendChild(element);
    }

    public void write(Writer writer) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(this.document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Can't write the configuration xml", e);
        }
    }
}

