/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.test.LambdaTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestHddsUtils {
    @Test
    public void testGetHostName() {
        Assert.assertEquals(Optional.of("localhost"), HddsUtils.getHostName("localhost:1234"));
        Assert.assertEquals(Optional.of("localhost"), HddsUtils.getHostName("localhost"));
        Assert.assertEquals(Optional.empty(), HddsUtils.getHostName(":1234"));
    }

    @Test
    public void validatePath() throws Exception {
        HddsUtils.validatePath(Paths.get("/", new String[0]), Paths.get("/", new String[0]));
        HddsUtils.validatePath(Paths.get("/a", new String[0]), Paths.get("/", new String[0]));
        HddsUtils.validatePath(Paths.get("/a", new String[0]), Paths.get("/a", new String[0]));
        HddsUtils.validatePath(Paths.get("/a/b", new String[0]), Paths.get("/a", new String[0]));
        HddsUtils.validatePath(Paths.get("/a/b/c", new String[0]), Paths.get("/a", new String[0]));
        HddsUtils.validatePath(Paths.get("/a/../a/b", new String[0]), Paths.get("/a", new String[0]));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath(Paths.get("/b/c", new String[0]), Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath(Paths.get("/", new String[0]), Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath(Paths.get("/a/..", new String[0]), Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath(Paths.get("/a/../b", new String[0]), Paths.get("/a", new String[0])));
    }

    @Test
    public void testGetSCMAddresses() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.setStrings("ozone.scm.names", new String[]{"1.2.3.4"});
        Collection<InetSocketAddress> addresses = HddsUtils.getSCMAddresses(conf);
        Assert.assertThat((Object)addresses.size(), (Matcher)Is.is((Object)1));
        InetSocketAddress addr = addresses.iterator().next();
        Assert.assertThat((Object)addr.getHostName(), (Matcher)Is.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.setStrings("ozone.scm.names", new String[]{"scm1"});
        addresses = HddsUtils.getSCMAddresses(conf);
        Assert.assertThat((Object)addresses.size(), (Matcher)Is.is((Object)1));
        addr = addresses.iterator().next();
        Assert.assertThat((Object)addr.getHostName(), (Matcher)Is.is((Object)"scm1"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234"});
        addresses = HddsUtils.getSCMAddresses(conf);
        Assert.assertThat((Object)addresses.size(), (Matcher)Is.is((Object)1));
        addr = addresses.iterator().next();
        Assert.assertThat((Object)addr.getHostName(), (Matcher)Is.is((Object)"scm1"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)1234));
        HashMap<String, Integer> hostsAndPorts = new HashMap<String, Integer>();
        hostsAndPorts.put("scm1", 1234);
        hostsAndPorts.put("scm2", 2345);
        hostsAndPorts.put("scm3", 3456);
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234,scm2:2345,scm3:3456"});
        addresses = HddsUtils.getSCMAddresses(conf);
        Assert.assertThat((Object)addresses.size(), (Matcher)Is.is((Object)3));
        Iterator<InetSocketAddress> it = addresses.iterator();
        HashMap expected1 = new HashMap(hostsAndPorts);
        while (it.hasNext()) {
            InetSocketAddress current = it.next();
            Assert.assertTrue((boolean)expected1.remove(current.getHostName(), current.getPort()));
        }
        Assert.assertTrue((boolean)expected1.isEmpty());
        conf.setStrings("ozone.scm.names", new String[]{" scm1:1234, scm2:2345 , scm3:3456 "});
        addresses = HddsUtils.getSCMAddresses(conf);
        Assert.assertThat((Object)addresses.size(), (Matcher)Is.is((Object)3));
        it = addresses.iterator();
        HashMap expected2 = new HashMap(hostsAndPorts);
        while (it.hasNext()) {
            InetSocketAddress current = it.next();
            Assert.assertTrue((boolean)expected2.remove(current.getHostName(), current.getPort()));
        }
        Assert.assertTrue((boolean)expected2.isEmpty());
        conf.setStrings("ozone.scm.names", new String[]{""});
        try {
            HddsUtils.getSCMAddresses(conf);
            Assert.fail((String)"Empty value should cause an IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        conf.setStrings("ozone.scm.names", new String[]{"s..x..:1234"});
        try {
            HddsUtils.getSCMAddresses(conf);
            Assert.fail((String)"An invalid hostname should cause an IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        conf.setStrings("ozone.scm.names", new String[]{"scm:xyz"});
        try {
            HddsUtils.getSCMAddresses(conf);
            Assert.fail((String)"An invalid port should cause an IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        conf.setStrings("ozone.scm.names", new String[]{"scm1:1234, scm:xyz"});
        try {
            HddsUtils.getSCMAddresses(conf);
            Assert.fail((String)"An invalid value should cause an IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

