/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OzoneFSInputStream
extends FSInputStream
implements ByteBufferReadable {
    private final InputStream inputStream;
    private final FileSystem.Statistics statistics;

    public OzoneFSInputStream(InputStream inputStream, FileSystem.Statistics statistics) {
        this.inputStream = inputStream;
        this.statistics = statistics;
    }

    public int read() throws IOException {
        int byteRead = this.inputStream.read();
        if (this.statistics != null && byteRead >= 0) {
            this.statistics.incrementBytesRead(1L);
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.inputStream.read(b, off, len);
        if (this.statistics != null && bytesRead >= 0) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public synchronized void close() throws IOException {
        this.inputStream.close();
    }

    public void seek(long pos) throws IOException {
        ((Seekable)this.inputStream).seek(pos);
    }

    public long getPos() throws IOException {
        return ((Seekable)this.inputStream).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public int read(ByteBuffer buf) throws IOException {
        int bytesRead;
        if (buf.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int readLen = Math.min(buf.remaining(), this.available());
        if (buf.hasArray()) {
            int pos = buf.position();
            bytesRead = this.read(buf.array(), pos, readLen);
            if (bytesRead > 0) {
                buf.position(pos + bytesRead);
            }
        } else {
            byte[] readData = new byte[readLen];
            bytesRead = this.read(readData, 0, readLen);
            if (bytesRead > 0) {
                buf.put(readData);
            }
        }
        return bytesRead;
    }
}

