/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.ozone.FilteredClassLoader;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneFSStorageStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientAdapterFactory {
    static final Logger LOG = LoggerFactory.getLogger(OzoneClientAdapterFactory.class);

    private OzoneClientAdapterFactory() {
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static OzoneClientAdapter createAdapter(String volumeStr, String bucketStr) throws IOException {
        return OzoneClientAdapterFactory.createAdapter(volumeStr, bucketStr, true, aClass -> (OzoneClientAdapter)aClass.getConstructor(String.class, String.class).newInstance(volumeStr, bucketStr));
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static OzoneClientAdapter createAdapter(String volumeStr, String bucketStr, StorageStatistics storageStatistics) throws IOException {
        return OzoneClientAdapterFactory.createAdapter(volumeStr, bucketStr, false, aClass -> (OzoneClientAdapter)aClass.getConstructor(String.class, String.class, OzoneFSStorageStatistics.class).newInstance(volumeStr, bucketStr, storageStatistics));
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static OzoneClientAdapter createAdapter(String volumeStr, String bucketStr, boolean basic, OzoneClientAdapterCreator creator) throws IOException {
        ClassLoader currentClassLoader = OzoneClientAdapterFactory.class.getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        OzoneClientAdapterFactory.findEmbeddedLibsUrl(urls, currentClassLoader);
        OzoneClientAdapterFactory.findConfigDirUrl(urls, currentClassLoader);
        FilteredClassLoader classLoader = new FilteredClassLoader(urls.toArray(new URL[0]), currentClassLoader);
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> reflectionUtils = ((ClassLoader)classLoader).loadClass("org.apache.ratis.util.ReflectionUtils");
            reflectionUtils.getMethod("getClassByName", String.class).invoke(null, "org.apache.ratis.grpc.GrpcFactory");
            Class<?> adapterClass = null;
            adapterClass = basic ? ((ClassLoader)classLoader).loadClass("org.apache.hadoop.fs.ozone.BasicOzoneClientAdapterImpl") : ((ClassLoader)classLoader).loadClass("org.apache.hadoop.fs.ozone.OzoneClientAdapterImpl");
            OzoneClientAdapter ozoneClientAdapter = creator.createOzoneClientAdapter(adapterClass);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return ozoneClientAdapter;
        }
        catch (Exception e) {
            LOG.error("Can't initialize the ozoneClientAdapter", (Throwable)e);
            throw new IOException("Can't initialize the OzoneClientAdapter implementation", e);
        }
    }

    private static void findConfigDirUrl(List<URL> urls, ClassLoader currentClassLoader) throws IOException {
        Enumeration<URL> conf = currentClassLoader.getResources("ozone-site.xml");
        while (conf.hasMoreElements()) {
            urls.add(new URL(conf.nextElement().toString().replace("ozone-site.xml", "")));
        }
    }

    private static void findEmbeddedLibsUrl(List<URL> urls, ClassLoader currentClassloader) throws MalformedURLException {
        String markerFile = "ozonefs.txt";
        ClassLoader currentClassLoader = OzoneClientAdapterFactory.class.getClassLoader();
        URL ozFs = currentClassLoader.getResource(markerFile);
        String rootPath = ozFs.toString().replace(markerFile, "");
        urls.add(new URL(rootPath));
        urls.add(new URL(rootPath + "libs/"));
    }

    @FunctionalInterface
    static interface OzoneClientAdapterCreator {
        public OzoneClientAdapter createOzoneClientAdapter(Class<?> var1) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException;
    }
}

