/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.util.StringUtils;

public class FilteredClassLoader
extends URLClassLoader {
    private final ClassLoader systemClassLoader;
    private final ClassLoader delegate;
    private Set<String> delegatedClasses = new HashSet<String>();

    public FilteredClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.delegatedClasses.add("org.apache.hadoop.crypto.key.KeyProvider");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.OzoneClientAdapter");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.FileStatusAdapter");
        this.delegatedClasses.add("org.apache.hadoop.security.token.Token");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.BasicKeyInfo");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.OzoneFSOutputStream");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.OzoneFSStorageStatistics");
        this.delegatedClasses.add("org.apache.hadoop.fs.ozone.Statistic");
        this.delegatedClasses.add("org.apache.hadoop.fs.Seekable");
        this.delegatedClasses.add("org.apache.hadoop.io.Text");
        this.delegatedClasses.add("org.apache.hadoop.fs.Path");
        this.delegatedClasses.add("org.apache.hadoop.fs.BlockLocation");
        this.delegatedClasses.addAll(StringUtils.getTrimmedStringCollection((String)System.getenv("HADOOP_OZONE_DELEGATED_CLASSES")));
        this.delegate = parent;
        this.systemClassLoader = FilteredClassLoader.getSystemClassLoader();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.delegatedClasses.contains(name) || name.startsWith("org.apache.log4j") || name.startsWith("org.slf4j")) {
            return this.delegate.loadClass(name);
        }
        return super.loadClass(name);
    }

    private Class<?> loadFromSystem(String name) {
        if (this.systemClassLoader != null) {
            try {
                return this.systemClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
        return null;
    }
}

