/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicOzoneClientAdapterImpl
implements OzoneClientAdapter {
    static final Logger LOG = LoggerFactory.getLogger(BasicOzoneClientAdapterImpl.class);
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private OzoneVolume volume;
    private OzoneBucket bucket;
    private ReplicationType replicationType;
    private ReplicationFactor replicationFactor;
    private boolean securityEnabled;
    private int configuredDnPort;

    public BasicOzoneClientAdapterImpl(String volumeStr, String bucketStr) throws IOException {
        this(BasicOzoneClientAdapterImpl.createConf(), volumeStr, bucketStr);
    }

    private static OzoneConfiguration createConf() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
            return ozoneConfiguration;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public BasicOzoneClientAdapterImpl(OzoneConfiguration conf, String volumeStr, String bucketStr) throws IOException {
        this(null, -1, conf, volumeStr, bucketStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicOzoneClientAdapterImpl(String omHost, int omPort, Configuration hadoopConf, String volumeStr, String bucketStr) throws IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            SecurityConfig secConfig;
            OzoneConfiguration conf = OzoneConfiguration.of(hadoopConf);
            if (omHost == null && OmUtils.isServiceIdsDefined(conf)) {
                throw new IllegalArgumentException("Service ID or host name must not be omitted when ozone.om.service.ids is defined.");
            }
            if (omPort != -1) {
                if (OmUtils.isOmHAServiceId(conf, omHost)) {
                    throw new IllegalArgumentException("Port " + omPort + " specified in URI but host '" + omHost + "' is a " + "logical (HA) OzoneManager and does not use port information.");
                }
            } else {
                omPort = OmUtils.getOmRpcPort(conf);
            }
            if ((secConfig = new SecurityConfig(conf)).isSecurityEnabled()) {
                this.securityEnabled = true;
            }
            String replicationTypeConf = conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT);
            int replicationCountConf = conf.getInt("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT);
            this.ozoneClient = OmUtils.isOmHAServiceId(conf, omHost) ? OzoneClientFactory.getRpcClient(omHost, (Configuration)conf) : (StringUtils.isNotEmpty((CharSequence)omHost) && omPort != -1 ? OzoneClientFactory.getRpcClient(omHost, omPort, conf) : OzoneClientFactory.getRpcClient(conf));
            this.objectStore = this.ozoneClient.getObjectStore();
            this.volume = this.objectStore.getVolume(volumeStr);
            this.bucket = this.volume.getBucket(bucketStr);
            this.replicationType = ReplicationType.valueOf(replicationTypeConf);
            this.replicationFactor = ReplicationFactor.valueOf(replicationCountConf);
            this.configuredDnPort = conf.getInt("dfs.container.ipc", 9859);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public short getDefaultReplication() {
        return (short)this.replicationFactor.getValue();
    }

    @Override
    public void close() throws IOException {
        this.ozoneClient.close();
    }

    @Override
    public InputStream readFile(String key) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_READ);
        try {
            return this.bucket.readFile(key).getInputStream();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    protected void incrementCounter(Statistic objectsRead) {
    }

    @Override
    public OzoneFSOutputStream createFile(String key, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED);
        try {
            OzoneOutputStream ozoneOutputStream = null;
            if (replication == ReplicationFactor.ONE.getValue() || replication == ReplicationFactor.THREE.getValue()) {
                ReplicationFactor clientReplication = ReplicationFactor.valueOf(replication);
                ozoneOutputStream = this.bucket.createFile(key, 0L, this.replicationType, clientReplication, overWrite, recursive);
            } else {
                ozoneOutputStream = this.bucket.createFile(key, 0L, this.replicationType, this.replicationFactor, overWrite, recursive);
            }
            return new OzoneFSOutputStream(ozoneOutputStream.getOutputStream());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public void renameKey(String key, String newKeyName) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED);
        this.bucket.renameKey(key, newKeyName);
    }

    @Override
    public boolean createDirectory(String keyName) throws IOException {
        LOG.trace("creating dir for key:{}", (Object)keyName);
        this.incrementCounter(Statistic.OBJECTS_CREATED);
        try {
            this.bucket.createDirectory(keyName);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS) {
                throw new FileAlreadyExistsException(e.getMessage());
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean deleteObject(String keyName) {
        LOG.trace("issuing delete for key {}", (Object)keyName);
        try {
            this.incrementCounter(Statistic.OBJECTS_DELETED);
            this.bucket.deleteKey(keyName);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public FileStatusAdapter getFileStatus(String key, URI uri, Path qualifiedPath, String userName) throws IOException {
        try {
            this.incrementCounter(Statistic.OBJECTS_QUERY);
            OzoneFileStatus status = this.bucket.getFileStatus(key);
            this.makeQualified(status, uri, qualifiedPath, userName);
            return this.toFileStatusAdapter(status);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(key + ": No such file or directory!");
            }
            throw e;
        }
    }

    public void makeQualified(FileStatus status, URI uri, Path path, String username) {
        if (status instanceof OzoneFileStatus) {
            ((OzoneFileStatus)status).makeQualified(uri, path, username, username);
        }
    }

    @Override
    public Iterator<BasicKeyInfo> listKeys(String pathKey) {
        this.incrementCounter(Statistic.OBJECTS_LIST);
        return new IteratorAdapter(this.bucket.listKeys(pathKey));
    }

    @Override
    public List<FileStatusAdapter> listStatus(String keyName, boolean recursive, String startKey, long numEntries, URI uri, Path workingDir, String username) throws IOException {
        try {
            this.incrementCounter(Statistic.OBJECTS_LIST);
            List<OzoneFileStatus> statuses = this.bucket.listStatus(keyName, recursive, startKey, numEntries);
            ArrayList<FileStatusAdapter> result = new ArrayList<FileStatusAdapter>();
            for (OzoneFileStatus status : statuses) {
                Path qualifiedPath = status.getPath().makeQualified(uri, workingDir);
                this.makeQualified(status, uri, qualifiedPath, username);
                result.add(this.toFileStatusAdapter(status));
            }
            return result;
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (!this.securityEnabled) {
            return null;
        }
        Token<OzoneTokenIdentifier> token = this.ozoneClient.getObjectStore().getDelegationToken(renewer == null ? null : new Text(renewer));
        token.setKind(OzoneTokenIdentifier.KIND_NAME);
        return token;
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return this.objectStore.getKeyProvider();
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return this.objectStore.getKeyProviderUri();
    }

    @Override
    public String getCanonicalServiceName() {
        return this.objectStore.getCanonicalServiceName();
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatus status) {
        return new FileStatusAdapter(status.getLen(), status.getPath(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission().toShort(), status.getOwner(), status.getGroup(), status.getPath(), this.getBlockLocations(status));
    }

    private BlockLocation[] getBlockLocations(OzoneFileStatus fileStatus) {
        if (fileStatus == null) {
            return new BlockLocation[0];
        }
        OmKeyInfo keyInfo = fileStatus.getKeyInfo();
        if (keyInfo == null || CollectionUtils.isEmpty(keyInfo.getKeyLocationVersions())) {
            return new BlockLocation[0];
        }
        List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups = keyInfo.getKeyLocationVersions();
        if (CollectionUtils.isEmpty(omKeyLocationInfoGroups)) {
            return new BlockLocation[0];
        }
        OmKeyLocationInfoGroup omKeyLocationInfoGroup = keyInfo.getLatestVersionLocations();
        BlockLocation[] blockLocations = new BlockLocation[omKeyLocationInfoGroup.getBlocksLatestVersionOnly().size()];
        int i = 0;
        long offsetOfBlockInFile = 0L;
        for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getBlocksLatestVersionOnly()) {
            ArrayList hostList = new ArrayList();
            ArrayList nameList = new ArrayList();
            omKeyLocationInfo.getPipeline().getNodes().forEach(dn -> {
                hostList.add(dn.getHostName());
                int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
                if (port == 0) {
                    port = this.configuredDnPort;
                }
                nameList.add(dn.getHostName() + ":" + port);
            });
            String[] hosts = hostList.toArray(new String[hostList.size()]);
            String[] names = nameList.toArray(new String[nameList.size()]);
            BlockLocation blockLocation = new BlockLocation(names, hosts, offsetOfBlockInFile, omKeyLocationInfo.getLength());
            offsetOfBlockInFile += omKeyLocationInfo.getLength();
            blockLocations[i++] = blockLocation;
        }
        return blockLocations;
    }

    public static class IteratorAdapter
    implements Iterator<BasicKeyInfo> {
        private Iterator<? extends OzoneKey> original;

        public IteratorAdapter(Iterator<? extends OzoneKey> listKeys) {
            this.original = listKeys;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public BasicKeyInfo next() {
            OzoneKey next = this.original.next();
            if (next == null) {
                return null;
            }
            return new BasicKeyInfo(next.getName(), next.getModificationTime().toEpochMilli(), next.getDataSize());
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public Text getKind() {
            return OzoneTokenIdentifier.KIND_NAME;
        }

        public boolean handleKind(Text kind) {
            return this.getKind().equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            Token<?> ozoneDt = token;
            OzoneClient ozoneClient = OzoneClientFactory.getRpcClient(conf);
            return ozoneClient.getObjectStore().renewDelegationToken(ozoneDt);
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            Token<?> ozoneDt = token;
            OzoneClient ozoneClient = OzoneClientFactory.getRpcClient(conf);
            ozoneClient.getObjectStore().cancelDelegationToken(ozoneDt);
        }

        static {
            OzoneConfiguration.activate();
        }
    }
}

