/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.KeyValueBasedTimelineStore;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreMapAdapter;
import org.apache.hadoop.yarn.server.timeline.util.LeveldbUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LevelDBCacheTimelineStore
extends KeyValueBasedTimelineStore {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBCacheTimelineStore.class);
    private static final String CACHED_LDB_FILE_PREFIX = "-timeline-cache.ldb";
    private String dbId;
    private DB entityDb;
    private Configuration configuration;

    public LevelDBCacheTimelineStore(String id, String name) {
        super(name);
        this.dbId = id;
        this.entityInsertTimes = new MemoryTimelineStore.HashMapStoreAdapter();
        this.domainById = new MemoryTimelineStore.HashMapStoreAdapter();
        this.domainsByOwner = new MemoryTimelineStore.HashMapStoreAdapter();
    }

    public LevelDBCacheTimelineStore(String id) {
        this(id, LevelDBCacheTimelineStore.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.configuration = conf;
        Options options = new Options();
        options.createIfMissing(true);
        options.cacheSize(conf.getLong("yarn.timeline-service.entity-group-fs-store.leveldb-cache-read-cache-size", 0xA00000L));
        JniDBFactory factory = new JniDBFactory();
        Path dbPath = new Path(conf.get("yarn.timeline-service.leveldb-timeline-store.path"), this.dbId + CACHED_LDB_FILE_PREFIX);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)conf);
            if (!localFS.exists(dbPath)) {
                if (!localFS.mkdirs(dbPath)) {
                    throw new IOException("Couldn't create directory for leveldb timeline store " + dbPath);
                }
                localFS.setPermission(dbPath, LeveldbUtils.LEVELDB_DIR_UMASK);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        LOG.info("Using leveldb path " + dbPath);
        this.entityDb = factory.open(new File(dbPath.toString()), options);
        this.entities = new LevelDBMapAdapter(this.entityDb);
        super.serviceInit(conf);
    }

    protected synchronized void serviceStop() throws Exception {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.entityDb});
        Path dbPath = new Path(this.configuration.get("yarn.timeline-service.leveldb-timeline-store.path"), this.dbId + CACHED_LDB_FILE_PREFIX);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)this.configuration);
            if (!localFS.delete(dbPath, true)) {
                throw new IOException("Couldn't delete data file for leveldb timeline store " + dbPath);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        super.serviceStop();
    }

    static class LevelDBMapAdapter<K extends EntityIdentifier, V extends TimelineEntity>
    implements TimelineStoreMapAdapter<K, V> {
        private static final String TIME_INDEX_PREFIX = "i";
        private static final String ENTITY_STORAGE_PREFIX = "e";
        DB entityDb;
        static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        public LevelDBMapAdapter(DB currLevelDb) {
            this.entityDb = currLevelDb;
        }

        public V get(K entityId) {
            V result = null;
            byte[] startTimeBytes = this.entityDb.get(this.getStartTimeKey(entityId));
            if (startTimeBytes == null) {
                return null;
            }
            try {
                result = this.getEntityForKey(this.getEntityKey(entityId, startTimeBytes));
            }
            catch (IOException e) {
                LOG.error("GenericObjectMapper cannot read key from key " + entityId.toString() + " into an object. Read aborted! ");
                LOG.error(e.getMessage());
            }
            return result;
        }

        public void put(K entityId, V entity) {
            Long startTime = entity.getStartTime();
            if (startTime == null) {
                startTime = System.currentTimeMillis();
            }
            byte[] startTimeBytes = GenericObjectMapper.writeReverseOrderedLong((long)startTime);
            try {
                byte[] valueBytes = GenericObjectMapper.write(entity);
                this.entityDb.put(this.getEntityKey(entityId, startTimeBytes), valueBytes);
            }
            catch (IOException e) {
                LOG.error("GenericObjectMapper cannot write " + entity.getClass().getName() + " into a byte array. Write aborted! ");
                LOG.error(e.getMessage());
            }
            this.entityDb.put(this.getStartTimeKey(entityId), startTimeBytes);
        }

        public void remove(K entityId) {
            LeveldbUtils.KeyBuilder startTimeKeyBuilder = LeveldbUtils.KeyBuilder.newInstance();
            startTimeKeyBuilder.add(TIME_INDEX_PREFIX).add(entityId.getId()).add(entityId.getType());
            byte[] startTimeBytes = this.entityDb.get(startTimeKeyBuilder.getBytes());
            if (startTimeBytes == null) {
                return;
            }
            this.entityDb.delete(startTimeKeyBuilder.getBytes());
            this.entityDb.delete(this.getEntityKey(entityId, startTimeBytes));
        }

        public TimelineStoreMapAdapter.CloseableIterator<V> valueSetIterator() {
            return this.getIterator(null, Long.MAX_VALUE);
        }

        public TimelineStoreMapAdapter.CloseableIterator<V> valueSetIterator(V minV) {
            return this.getIterator(new EntityIdentifier(minV.getEntityId(), minV.getEntityType()), minV.getStartTime());
        }

        private TimelineStoreMapAdapter.CloseableIterator<V> getIterator(EntityIdentifier startId, long startTimeMax) {
            final DBIterator internalDbIterator = this.entityDb.iterator();
            LeveldbUtils.KeyBuilder entityPrefixKeyBuilder = LeveldbUtils.KeyBuilder.newInstance();
            entityPrefixKeyBuilder.add(ENTITY_STORAGE_PREFIX);
            final byte[] prefixBytes = entityPrefixKeyBuilder.getBytesForLookup();
            byte[] startTimeBytes = GenericObjectMapper.writeReverseOrderedLong((long)startTimeMax);
            entityPrefixKeyBuilder.add(startTimeBytes, true);
            if (startId != null) {
                entityPrefixKeyBuilder.add(startId.getId());
            }
            byte[] startPrefixBytes = entityPrefixKeyBuilder.getBytesForLookup();
            internalDbIterator.seek(startPrefixBytes);
            return new TimelineStoreMapAdapter.CloseableIterator<V>(){

                public boolean hasNext() {
                    if (!internalDbIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry nextEntry = internalDbIterator.peekNext();
                    return LeveldbUtils.prefixMatches((byte[])prefixBytes, (int)prefixBytes.length, (byte[])((byte[])nextEntry.getKey()));
                }

                public V next() {
                    if (this.hasNext()) {
                        Map.Entry nextRaw = (Map.Entry)internalDbIterator.next();
                        try {
                            TimelineEntity result = this.getEntityForKey((byte[])nextRaw.getKey());
                            return result;
                        }
                        catch (IOException e) {
                            LOG.error("GenericObjectMapper cannot read key from key " + nextRaw.getKey() + " into an object. Read aborted! ");
                            LOG.error(e.getMessage());
                        }
                    }
                    return null;
                }

                public void remove() {
                    LOG.error("LevelDB map adapter does not support iterate-and-remove use cases. ");
                }

                public void close() throws IOException {
                    internalDbIterator.close();
                }
            };
        }

        private V getEntityForKey(byte[] key) throws IOException {
            byte[] resultRaw = this.entityDb.get(key);
            if (resultRaw == null) {
                return null;
            }
            return (V)((TimelineEntity)OBJECT_MAPPER.readValue(resultRaw, TimelineEntity.class));
        }

        private byte[] getStartTimeKey(K entityId) {
            LeveldbUtils.KeyBuilder startTimeKeyBuilder = LeveldbUtils.KeyBuilder.newInstance();
            startTimeKeyBuilder.add(TIME_INDEX_PREFIX).add(entityId.getId()).add(entityId.getType());
            return startTimeKeyBuilder.getBytes();
        }

        private byte[] getEntityKey(K entityId, byte[] startTimeBytes) {
            LeveldbUtils.KeyBuilder entityKeyBuilder = LeveldbUtils.KeyBuilder.newInstance();
            entityKeyBuilder.add(ENTITY_STORAGE_PREFIX).add(startTimeBytes, true).add(entityId.getId()).add(entityId.getType());
            return entityKeyBuilder.getBytes();
        }
    }
}

