/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hbase.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hbase.client.HBaseClient;
import org.apache.ranger.services.hbase.client.HBaseConnectionMgr;

public class HBaseResourceMgr {
    private static final Logger LOG = Logger.getLogger(HBaseResourceMgr.class);
    private static final String TABLE = "table";
    private static final String COLUMNFAMILY = "column-family";

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HBaseResourceMgr.connectionTest() ServiceName: " + serviceName + "Configs" + configs));
        }
        try {
            ret = HBaseClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error((Object)("<== HBaseResourceMgr.connectionTest() Error: " + (Object)((Object)e)));
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HBaseResourceMgr.connectionTest() Result: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHBaseResource(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block24: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            String tableName = null;
            String columnFamilies = null;
            List tableList = null;
            List columnFamilyList = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== HBaseResourceMgr.getHBaseResource UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap));
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    tableList = (List)resourceMap.get(TABLE);
                    columnFamilyList = (List)resourceMap.get(COLUMNFAMILY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column-family": {
                        columnFamilies = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                final List finaltableList = tableList;
                final List finalcolumnFamilyList = columnFamilyList;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<== HBaseResourceMgr.getHBaseResource UserInput: \"" + userInput + "\" configs: " + configs + " context: " + context));
                    }
                    final HBaseClient hBaseClient = new HBaseConnectionMgr().getHBaseConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    if (hBaseClient == null) break block24;
                    if (tableName != null && !tableName.isEmpty()) {
                        if (!tableName.endsWith("*")) {
                            tableName = tableName + "*";
                        }
                        final String finalTableName = tableName = tableName.replaceAll("\\*", ".\\*");
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hBaseClient.getTableList(finalTableName, finaltableList);
                            }
                        };
                    } else if (columnFamilies != null && !columnFamilies.isEmpty()) {
                        if (!columnFamilies.endsWith("*")) {
                            columnFamilies = columnFamilies + "*";
                        }
                        final String finalColFamilies = columnFamilies = columnFamilies.replaceAll("\\*", ".\\*");
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hBaseClient.getColumnFamilyList(finalColFamilies, finaltableList, finalcolumnFamilyList);
                            }
                        };
                    }
                    if (callableObj == null) break block24;
                    HBaseClient hBaseClient2 = hBaseClient;
                    synchronized (hBaseClient2) {
                        resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to get hbase resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HBaseResourceMgr.getHBaseResource() Result :" + resultList));
        }
        return resultList;
    }
}

