/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hbase.client;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;

public class HBaseClient
extends BaseClient {
    private static final Log LOG = LogFactory.getLog(HBaseClient.class);
    private static Subject subj = null;
    private Configuration conf = HBaseConfiguration.create();

    public HBaseClient(String serivceName, Map<String, String> connectionProp) {
        super(serivceName, HBaseClient.addDefaultHBaseProp(connectionProp));
        Set rangerInternalPropertyKeys = this.getConfigHolder().getRangerInternalPropertyKeys();
        for (Map.Entry entry : this.connectionProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (rangerInternalPropertyKeys.contains(key)) continue;
            this.conf.set(key, value);
        }
    }

    private static Map<String, String> addDefaultHBaseProp(Map<String, String> connectionProp) {
        if (connectionProp != null) {
            String param = "zookeeper.znode.parent";
            String unsecuredPath = "/hbase-unsecure";
            String authParam = "hadoop.security.authorization";
            String ret = connectionProp.get(param);
            LOG.info((Object)("HBase connection has [" + param + "] with value [" + ret + "]"));
            if (ret == null) {
                ret = connectionProp.get(authParam);
                LOG.info((Object)("HBase connection has [" + authParam + "] with value [" + ret + "]"));
                if (ret != null && ret.trim().equalsIgnoreCase("false")) {
                    LOG.info((Object)("HBase connection is resetting [" + param + "] with value [" + unsecuredPath + "]"));
                    connectionProp.put(param, unsecuredPath);
                }
            }
        }
        return connectionProp;
    }

    public static Map<String, Object> connectionTest(String dataSource, Map<String, String> configs) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        boolean connectivityStatus = false;
        HBaseClient connectionObj = new HBaseClient(dataSource, configs);
        if (connectionObj != null) {
            try {
                connectivityStatus = connectionObj.getHBaseStatus();
            }
            catch (HadoopException e) {
                LOG.error((Object)"<== HBaseClient.testConnection(): Unable to retrieve any databases using given parameters", (Throwable)e);
                throw e;
            }
        }
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful";
            HBaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any databases using given parameters.";
            HBaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info."), null, null, responseData);
        }
        return responseData;
    }

    public boolean getHBaseStatus() throws HadoopException {
        boolean hbaseStatus = false;
        subj = this.getLoginSubject();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        if (subj != null) {
            try {
                hbaseStatus = Subject.doAs(subj, new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        Boolean hbaseStatus1 = false;
                        try {
                            LOG.info((Object)"getHBaseStatus: creating default Hbase configuration");
                            LOG.info((Object)"getHBaseStatus: setting config values from client");
                            HBaseClient.this.setClientConfigValues(HBaseClient.this.conf);
                            LOG.info((Object)"getHBaseStatus: checking HbaseAvailability with the new config");
                            HBaseAdmin.available((Configuration)HBaseClient.this.conf);
                            LOG.info((Object)"getHBaseStatus: no exception: HbaseAvailability true");
                            hbaseStatus1 = true;
                        }
                        catch (ZooKeeperConnectionException zce) {
                            String msgDesc = "getHBaseStatus: Unable to connect to `ZooKeeper` using given config parameters.";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)zce);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)zce), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + (Object)((Object)zce)));
                            throw hdpException;
                        }
                        catch (MasterNotRunningException mnre) {
                            String msgDesc = "getHBaseStatus: Looks like `Master` is not running, so couldn't check that running HBase is available or not, Please try again later.";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)mnre);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)mnre), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + (Object)((Object)mnre)));
                            throw hdpException;
                        }
                        catch (IOException io) {
                            String msgDesc = "getHBaseStatus: Unable to check availability of Hbase environment [" + HBaseClient.this.getConfigHolder().getDatasourceName() + "].";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)io);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)io), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + io));
                            throw hdpException;
                        }
                        catch (Throwable e) {
                            String msgDesc = "getHBaseStatus: Unable to check availability of Hbase environment [" + HBaseClient.this.getConfigHolder().getDatasourceName() + "].";
                            LOG.error((Object)(msgDesc + e));
                            hbaseStatus1 = false;
                            HadoopException hdpException = new HadoopException(msgDesc, e);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            throw hdpException;
                        }
                        return hbaseStatus1;
                    }
                });
            }
            catch (SecurityException se) {
                String msgDesc = "getHBaseStatus: Unable to connect to HBase Server instance ";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, HBaseClient.getMessage((Throwable)se), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                LOG.error((Object)(msgDesc + se));
                throw hdpException;
            }
        } else {
            LOG.error((Object)"getHBaseStatus: secure login not done, subject is null");
        }
        return hbaseStatus;
    }

    private void setClientConfigValues(Configuration conf) {
        if (this.connectionProperties == null) {
            return;
        }
        for (Map.Entry e : this.connectionProperties.entrySet()) {
            String v = conf.get((String)e.getKey());
            if (v == null || v.equalsIgnoreCase((String)e.getValue())) continue;
            conf.set((String)e.getKey(), (String)e.getValue());
        }
    }

    public List<String> getTableList(final String tableNameMatching, final List<String> existingTableList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseClient.getTableList()  tableNameMatching " + tableNameMatching + " ExisitingTableList " + existingTableList));
        }
        List<String> ret = null;
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        subj = this.getLoginSubject();
        if (subj != null) {
            ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    ArrayList<String> tableList = new ArrayList<String>();
                    Admin admin = null;
                    try {
                        LOG.info((Object)"getTableList: setting config values from client");
                        HBaseClient.this.setClientConfigValues(HBaseClient.this.conf);
                        LOG.info((Object)"getTableList: checking HbaseAvailability with the new config");
                        Connection conn = ConnectionFactory.createConnection((Configuration)HBaseClient.this.conf);
                        LOG.info((Object)"getTableList: no exception: HbaseAvailability true");
                        admin = conn.getAdmin();
                        List htds = admin.listTableDescriptors(Pattern.compile(tableNameMatching));
                        if (htds != null) {
                            for (TableDescriptor htd : htds) {
                                String tableName = htd.getTableName().getNameAsString();
                                if (existingTableList != null && existingTableList.contains(tableName)) continue;
                                tableList.add(htd.getTableName().getNameAsString());
                            }
                        } else {
                            LOG.error((Object)"getTableList: null HTableDescription received from HBaseAdmin.listTables");
                        }
                    }
                    catch (ZooKeeperConnectionException zce) {
                        String msgDesc = "getTableList: Unable to connect to `ZooKeeper` using given config parameters.";
                        HadoopException hdpException = new HadoopException(msgDesc, (Throwable)zce);
                        hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)zce), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                        LOG.error((Object)(msgDesc + (Object)((Object)zce)));
                        throw hdpException;
                    }
                    catch (MasterNotRunningException mnre) {
                        String msgDesc = "getTableList: Looks like `Master` is not running, so couldn't check that running HBase is available or not, Please try again later.";
                        HadoopException hdpException = new HadoopException(msgDesc, (Throwable)mnre);
                        hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)mnre), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                        LOG.error((Object)(msgDesc + (Object)((Object)mnre)));
                        throw hdpException;
                    }
                    catch (IOException io) {
                        String msgDesc = "getTableList: Unable to get HBase table List for [repository:" + HBaseClient.this.getConfigHolder().getDatasourceName() + ",table-match:" + tableNameMatching + "].";
                        HadoopException hdpException = new HadoopException(msgDesc, (Throwable)io);
                        hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)io), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                        LOG.error((Object)(msgDesc + io));
                        throw hdpException;
                    }
                    catch (Throwable e) {
                        String msgDesc = "getTableList : Unable to get HBase table List for [repository:" + HBaseClient.this.getConfigHolder().getDatasourceName() + ",table-match:" + tableNameMatching + "].";
                        LOG.error((Object)(msgDesc + e));
                        HadoopException hdpException = new HadoopException(msgDesc, e);
                        hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                        throw hdpException;
                    }
                    finally {
                        if (admin != null) {
                            try {
                                admin.close();
                            }
                            catch (IOException e) {
                                LOG.error((Object)("Unable to close HBase connection [" + HBaseClient.this.getConfigHolder().getDatasourceName() + "]"), (Throwable)e);
                            }
                        }
                    }
                    return tableList;
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseClient.getTableList() " + ret));
        }
        return ret;
    }

    public List<String> getColumnFamilyList(final String columnFamilyMatching, final List<String> tableList, final List<String> existingColumnFamilies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseClient.getColumnFamilyList()  columnFamilyMatching " + columnFamilyMatching + " ExisitingTableList " + tableList + "existingColumnFamilies " + existingColumnFamilies));
        }
        List<String> ret = null;
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        subj = this.getLoginSubject();
        if (subj != null) {
            try {
                ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){
                    String tblName = null;

                    @Override
                    public List<String> run() {
                        ArrayList<String> colfList = new ArrayList<String>();
                        Admin admin = null;
                        try {
                            LOG.info((Object)"getColumnFamilyList: setting config values from client");
                            HBaseClient.this.setClientConfigValues(HBaseClient.this.conf);
                            LOG.info((Object)"getColumnFamilyList: checking HbaseAvailability with the new config");
                            Connection conn = ConnectionFactory.createConnection((Configuration)HBaseClient.this.conf);
                            LOG.info((Object)"getColumnFamilyList: no exception: HbaseAvailability true");
                            admin = conn.getAdmin();
                            if (tableList != null) {
                                Iterator iterator = tableList.iterator();
                                while (iterator.hasNext()) {
                                    String tableName;
                                    this.tblName = tableName = (String)iterator.next();
                                    TableDescriptor htd = admin.getDescriptor(TableName.valueOf((String)tableName));
                                    if (htd == null) continue;
                                    for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                                        String colf = hcd.getNameAsString();
                                        if (!colf.matches(columnFamilyMatching) || existingColumnFamilies != null && existingColumnFamilies.contains(colf)) continue;
                                        colfList.add(colf);
                                    }
                                }
                            }
                        }
                        catch (ZooKeeperConnectionException zce) {
                            String msgDesc = "getColumnFamilyList: Unable to connect to `ZooKeeper` using given config parameters.";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)zce);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)zce), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + (Object)((Object)zce)));
                            throw hdpException;
                        }
                        catch (MasterNotRunningException mnre) {
                            String msgDesc = "getColumnFamilyList: Looks like `Master` is not running, so couldn't check that running HBase is available or not, Please try again later.";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)mnre);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)mnre), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + (Object)((Object)mnre)));
                            throw hdpException;
                        }
                        catch (IOException io) {
                            String msgDesc = "getColumnFamilyList: Unable to get HBase ColumnFamilyList for [repository:" + HBaseClient.this.getConfigHolder().getDatasourceName() + ",table:" + this.tblName + ", table-match:" + columnFamilyMatching + "] ";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)io);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)io), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + io));
                            throw hdpException;
                        }
                        catch (SecurityException se) {
                            String msgDesc = "getColumnFamilyList: Unable to get HBase ColumnFamilyList for [repository:" + HBaseClient.this.getConfigHolder().getDatasourceName() + ",table:" + this.tblName + ", table-match:" + columnFamilyMatching + "] ";
                            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)se), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + se));
                            throw hdpException;
                        }
                        catch (Throwable e) {
                            String msgDesc = "getColumnFamilyList: Unable to get HBase ColumnFamilyList for [repository:" + HBaseClient.this.getConfigHolder().getDatasourceName() + ",table:" + this.tblName + ", table-match:" + columnFamilyMatching + "] ";
                            LOG.error((Object)msgDesc);
                            HadoopException hdpException = new HadoopException(msgDesc, e);
                            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                            LOG.error((Object)(msgDesc + e));
                            throw hdpException;
                        }
                        finally {
                            if (admin != null) {
                                try {
                                    admin.close();
                                }
                                catch (IOException e) {
                                    LOG.error((Object)("Unable to close HBase connection [" + HBaseClient.this.getConfigHolder().getDatasourceName() + "]"), (Throwable)e);
                                }
                            }
                        }
                        return colfList;
                    }
                });
            }
            catch (SecurityException se) {
                String msgDesc = "getColumnFamilyList: Unable to connect to HBase Server instance ";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, HBaseClient.getMessage((Throwable)se), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                LOG.error((Object)(msgDesc + se));
                throw hdpException;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseClient.getColumnFamilyList() " + ret));
        }
        return ret;
    }
}

