/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

public class RangerHBaseResource
extends RangerAccessResourceImpl {
    public static final String KEY_TABLE = "table";
    public static final String KEY_COLUMN_FAMILY = "column-family";
    public static final String KEY_COLUMN = "column";
    public static final String WILDCARD = "*";
    public static final String NAMESPACE_SEPARATOR = ":";
    public static final String DEFAULT_NAMESPACE = "default:";

    public RangerHBaseResource() {
    }

    public RangerHBaseResource(Map<String, Object> elements) {
        super(elements);
        this.setValue(KEY_TABLE, this.getValue(KEY_TABLE));
    }

    public RangerHBaseResource(Map<String, Object> elements, String ownerUser) {
        super(elements, ownerUser);
        this.setValue(KEY_TABLE, this.getValue(KEY_TABLE));
    }

    public void setValue(String key, Object value) {
        if (StringUtils.equals((String)key, (String)KEY_TABLE) && value instanceof String) {
            String tableName = (String)((Object)value);
            if (!tableName.contains(NAMESPACE_SEPARATOR)) {
                ArrayList<String> tableNames = new ArrayList<String>(2);
                tableNames.add(tableName);
                tableNames.add(DEFAULT_NAMESPACE + tableName);
                value = tableNames;
            } else if (StringUtils.startsWith((String)tableName, (String)DEFAULT_NAMESPACE)) {
                ArrayList<String> tableNames = new ArrayList<String>(2);
                tableNames.add(tableName);
                tableNames.add(tableName.substring(DEFAULT_NAMESPACE.length()));
                value = tableNames;
            }
        }
        super.setValue(key, (Object)value);
    }

    void resetValue(String key) {
        List tableNames;
        Object value;
        if (StringUtils.equals((String)key, (String)KEY_TABLE) && (value = this.getValue(key)) instanceof List && !(tableNames = (List)value).isEmpty()) {
            super.setValue(key, tableNames.get(0));
        }
    }
}

