/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.security.AccessControlException;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.AuthorizationSession;
import org.apache.ranger.authorization.hbase.ColumnIterator;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseAuthUtils;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.apache.ranger.authorization.hbase.HbaseUserUtils;
import org.apache.ranger.authorization.hbase.RangerAuthorizationFilter;
import org.apache.ranger.authorization.hbase.RangerHBasePlugin;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerAuthorizationCoprocessor
implements AccessControlProtos.AccessControlService.Interface,
RegionCoprocessor,
MasterCoprocessor,
RegionServerCoprocessor,
MasterObserver,
RegionObserver,
RegionServerObserver,
EndpointObserver,
BulkLoadObserver,
Coprocessor {
    private static final Log LOG = LogFactory.getLog((String)RangerAuthorizationCoprocessor.class.getName());
    private static final Log PERF_HBASEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hbaseauth.request");
    private static boolean UpdateRangerPoliciesOnGrantRevoke = true;
    private static final String GROUP_PREFIX = "@";
    private UserProvider userProvider;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private boolean shouldCheckExecPermission;
    final HbaseFactory _factory = HbaseFactory.getInstance();
    final HbaseUserUtils _userUtils = this._factory.getUserUtils();
    final HbaseAuthUtils _authUtils = this._factory.getAuthUtils();
    private static volatile RangerHBasePlugin hbasePlugin = null;
    private String coprocessorType = "unknown";
    private static final String MASTER_COPROCESSOR_TYPE = "master";
    private static final String REGIONAL_COPROCESSOR_TYPE = "regional";
    private static final String REGIONAL_SERVER_COPROCESSOR_TYPE = "regionalServer";

    protected byte[] getTableName(RegionCoprocessorEnvironment e) {
        RegionInfo regionInfo;
        Region region = e.getRegion();
        byte[] tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTable().getName();
        }
        return tableName;
    }

    protected void requireSystemOrSuperUser(Configuration conf, ObserverContext<?> ctx) throws IOException {
        User activeUser;
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String systemUser = user.getShortName();
        if (!Objects.equals(systemUser, (activeUser = this.getActiveUser(ctx)).getShortName()) && !this._userUtils.isSuperUser(activeUser)) {
            throw new AccessDeniedException("User '" + user.getShortName() + "is not system or super user.");
        }
    }

    protected boolean isSpecialTable(RegionInfo regionInfo) {
        return this.isSpecialTable(regionInfo.getTable().getName());
    }

    protected boolean isSpecialTable(byte[] tableName) {
        return this.isSpecialTable(Bytes.toString((byte[])tableName));
    }

    protected boolean isSpecialTable(String input) {
        String[] specialTables;
        for (String specialTable : specialTables = new String[]{"hbase:meta", "-ROOT-", ".META.", "hbase:acl", "hbase:namespace"}) {
            if (!specialTable.equals(input)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAccessForMetaTables(RegionCoprocessorEnvironment env) {
        RegionInfo hri = env.getRegion().getRegionInfo();
        return hri.isMetaRegion();
    }

    private User getActiveUser(ObserverContext<?> ctx) {
        User user = null;
        if (ctx != null) {
            try {
                Optional optionalUser = ctx.getCaller();
                user = optionalUser.isPresent() ? (User)optionalUser.get() : this.userProvider.getCurrent();
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to get request user using context" + ctx));
            }
        }
        if (user == null) {
            try {
                user = (User)RpcServer.getRequestUser().get();
            }
            catch (NoSuchElementException e) {
                LOG.info((Object)"Unable to get request user via RPCServer");
            }
        }
        if (user == null) {
            try {
                user = User.getCurrent();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to find the current user");
                user = null;
            }
        }
        return user;
    }

    private String getRemoteAddress() {
        InetAddress remoteAddr = null;
        try {
            remoteAddr = (InetAddress)RpcServer.getRemoteAddress().get();
        }
        catch (NoSuchElementException e) {
            LOG.info((Object)"Unable to get remote Address");
        }
        if (remoteAddr == null) {
            remoteAddr = RpcServer.getRemoteIp();
        }
        String strAddr = remoteAddr != null ? remoteAddr.getHostAddress() : null;
        return strAddr;
    }

    private void requireScannerOwner(ObserverContext<?> ctx, InternalScanner s) throws AccessDeniedException {
        if (!RpcServer.isInRpcCallContext()) {
            return;
        }
        User user = this.getActiveUser(ctx);
        String requestUserName = user.getShortName();
        String owner = this.scannerOwners.get(s);
        if (owner != null && !owner.equals(requestUserName)) {
            throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
        }
    }

    Map<String, Set<String>> getColumnFamilies(Map<byte[], ? extends Collection<?>> families) {
        if (families == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<byte[], Collection<?>> anEntry : families.entrySet()) {
            byte[] familyBytes = anEntry.getKey();
            String family = Bytes.toString((byte[])familyBytes);
            if (family == null || family.isEmpty()) {
                LOG.error((Object)"Unexpected Input: got null or empty column family (key) in families map! Ignoring...");
                continue;
            }
            Collection<?> columnCollection = anEntry.getValue();
            if (CollectionUtils.isEmpty(columnCollection)) {
                result.put(family, Collections.emptySet());
                continue;
            }
            ColumnIterator columnIterator = new ColumnIterator(columnCollection);
            HashSet<String> columns = new HashSet<String>();
            try {
                while (columnIterator.hasNext()) {
                    String column = (String)columnIterator.next();
                    columns.add(column);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)("Exception encountered when converting family-map to set of columns. Ignoring and returning empty set of columns for family[" + family + "]"), t);
                LOG.error((Object)("Ignoring exception and returning empty set of columns for family[" + family + "]"));
                columns.clear();
            }
            result.put(family, columns);
        }
        return result;
    }

    ColumnFamilyAccessResult evaluateAccess(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> familyMap) throws AccessDeniedException {
        byte[] tableBytes;
        String access = this._authUtils.getAccess(action);
        User user = this.getActiveUser(ctx);
        String userName = this._userUtils.getUserAsString(user);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("evaluateAccess: entered: user[%s], Operation[%s], access[%s], families[%s]", userName, operation, access, this.getColumnFamilies(familyMap).toString()));
        }
        if ((tableBytes = this.getTableName(env)) == null || tableBytes.length == 0) {
            String message = "evaluateAccess: Unexpected: Couldn't get table from RegionCoprocessorEnvironment. Access denied, not audited";
            LOG.debug((Object)message);
            throw new AccessDeniedException("Insufficient permissions for operation '" + operation + "',action: " + action);
        }
        String table = Bytes.toString((byte[])tableBytes);
        String messageTemplate = "evaluateAccess: exiting: user[%s], Operation[%s], access[%s], families[%s], verdict[%s]";
        if (this.canSkipAccessCheck(user, operation, access, table) || this.canSkipAccessCheck(user, operation, access, env)) {
            LOG.debug((Object)"evaluateAccess: exiting: isKnownAccessPattern returned true: access allowed, not audited");
            ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(true, true, null, null, null, null, null);
            if (LOG.isDebugEnabled()) {
                Map<String, Set<String>> families = this.getColumnFamilies(familyMap);
                String message = String.format("evaluateAccess: exiting: user[%s], Operation[%s], access[%s], families[%s], verdict[%s]", userName, operation, access, families.toString(), result.toString());
                LOG.debug((Object)message);
            }
            return result;
        }
        HbaseAuditHandler auditHandler = this._factory.getAuditHandler();
        AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access).table(table);
        Map<String, Set<String>> families = this.getColumnFamilies(familyMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("evaluateAccess: families to process: " + families.toString()));
        }
        if (families == null || families.isEmpty()) {
            LOG.debug((Object)"evaluateAccess: Null or empty families collection, ok.  Table level access is desired");
            session.buildRequest().authorize();
            boolean authorized = session.isAuthorized();
            String reason = "";
            if (authorized) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("evaluateAccess: table level access granted [" + table + "]"));
                }
            } else {
                reason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, no column families found.", user.getName(), operation, table);
            }
            AuthzAuditEvent event = auditHandler.getAndDiscardMostRecentEvent();
            ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(authorized, authorized, authorized ? Collections.singletonList(event) : null, null, authorized ? null : event, reason, null);
            if (LOG.isDebugEnabled()) {
                String message = String.format("evaluateAccess: exiting: user[%s], Operation[%s], access[%s], families[%s], verdict[%s]", userName, operation, access, families.toString(), result.toString());
                LOG.debug((Object)message);
            }
            return result;
        }
        LOG.debug((Object)"evaluateAccess: Families collection not null. will do finer level check");
        boolean everythingIsAccessible = true;
        boolean somethingIsAccessible = false;
        ArrayList<AuthzAuditEvent> authorizedEvents = new ArrayList<AuthzAuditEvent>();
        ArrayList<AuthzAuditEvent> familyLevelAccessEvents = new ArrayList<AuthzAuditEvent>();
        AuthzAuditEvent deniedEvent = null;
        String denialReason = null;
        HashMap<String, Set<String>> columnsAccessAllowed = new HashMap<String, Set<String>>();
        HashSet<String> familesAccessAllowed = new HashSet<String>();
        HashSet<String> familesAccessDenied = new HashSet<String>();
        HashSet<String> familesAccessIndeterminate = new HashSet<String>();
        for (Map.Entry<String, Set<String>> anEntry : families.entrySet()) {
            Set<String> columns;
            String family = anEntry.getKey();
            session.columnFamily(family);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("evaluateAccess: Processing family: " + family));
            }
            if ((columns = anEntry.getValue()) == null || columns.isEmpty()) {
                LOG.debug((Object)"evaluateAccess: columns collection null or empty, ok.  Family level access is desired.");
                session.column(null).buildRequest().authorize();
                AuthzAuditEvent auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                boolean isColumnFamilyAuthorized = session.isAuthorized();
                if (auditEvent != null) {
                    if (isColumnFamilyAuthorized) {
                        familyLevelAccessEvents.add(auditEvent);
                    } else if (deniedEvent == null) {
                        LOG.debug((Object)"evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                        deniedEvent = auditEvent;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("evaluateAccess: family level access for [" + family + "] is evaluated to " + isColumnFamilyAuthorized + ". Checking if [" + family + "] descendants have access."));
                }
                session.resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS).buildRequest().authorize();
                auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                if (session.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("evaluateAccess: [" + family + "] descendants have access"));
                    }
                    somethingIsAccessible = true;
                    if (isColumnFamilyAuthorized) {
                        familesAccessAllowed.add(family);
                        if (auditEvent != null) {
                            LOG.debug((Object)"evaluateAccess: adding to family-level-access-granted-event-set");
                            familyLevelAccessEvents.add(auditEvent);
                        }
                    } else {
                        familesAccessIndeterminate.add(family);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("evaluateAccess: has partial access (of some type) in family [" + family + "]"));
                        }
                        everythingIsAccessible = false;
                        if (auditEvent != null && deniedEvent == null) {
                            LOG.debug((Object)"evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                            deniedEvent = auditEvent;
                        }
                    }
                } else {
                    everythingIsAccessible = false;
                    if (isColumnFamilyAuthorized) {
                        somethingIsAccessible = true;
                        familesAccessIndeterminate.add(family);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("evaluateAccess: has partial access (of some type) in family [" + family + "]"));
                        }
                        if (auditEvent != null && deniedEvent == null) {
                            LOG.debug((Object)"evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                            deniedEvent = auditEvent;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("evaluateAccess: has no access of [" + access + "] type in family [" + family + "]"));
                        }
                        familesAccessDenied.add(family);
                        denialReason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, family:%s.", user.getName(), operation, table, family);
                    }
                }
                session.resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF);
                continue;
            }
            LOG.debug((Object)"evaluateAccess: columns collection not empty.  Skipping Family level check, will do finer level access check.");
            HashSet<String> accessibleColumns = new HashSet<String>();
            for (String column : columns) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("evaluateAccess: Processing column: " + column));
                }
                session.column(column).buildRequest().authorize();
                AuthzAuditEvent auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                if (session.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("evaluateAccess: has column level access [" + family + ", " + column + "]"));
                    }
                    somethingIsAccessible = true;
                    accessibleColumns.add(column);
                    if (auditEvent != null) {
                        LOG.debug((Object)"evaluateAccess: adding to access-granted-audit-event-set");
                        authorizedEvents.add(auditEvent);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("evaluateAccess: no column level access [" + family + ", " + column + "]"));
                    }
                    somethingIsAccessible = false;
                    everythingIsAccessible = false;
                    denialReason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, family:%s, column: %s", user.getName(), operation, table, family, column);
                    if (auditEvent != null && deniedEvent == null) {
                        LOG.debug((Object)"evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                        deniedEvent = auditEvent;
                    }
                }
                if (accessibleColumns.isEmpty()) continue;
                columnsAccessAllowed.put(family, accessibleColumns);
            }
        }
        RangerAuthorizationFilter filter = new RangerAuthorizationFilter(session, familesAccessAllowed, familesAccessDenied, familesAccessIndeterminate, columnsAccessAllowed);
        ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(everythingIsAccessible, somethingIsAccessible, authorizedEvents, familyLevelAccessEvents, deniedEvent, denialReason, filter);
        if (LOG.isDebugEnabled()) {
            String message = String.format("evaluateAccess: exiting: user[%s], Operation[%s], access[%s], families[%s], verdict[%s]", userName, operation, access, families.toString(), result.toString());
            LOG.debug((Object)message);
        }
        return result;
    }

    Filter authorizeAccess(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment env, Map<byte[], NavigableSet<byte[]>> familyMap) throws AccessDeniedException {
        RangerDefaultAuditHandler auditHandler;
        ColumnFamilyAccessResult accessResult;
        block9: {
            RangerPerfTracer perf;
            block8: {
                Filter filter;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"==> authorizeAccess");
                }
                perf = null;
                try {
                    perf = RangerPerfTracer.getPerfTracer((Log)PERF_HBASEAUTH_REQUEST_LOG, (String)("RangerAuthorizationCoprocessor.authorizeAccess(request=Operation[" + operation + "]"));
                    accessResult = this.evaluateAccess(ctx, operation, action, env, familyMap);
                    auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    if (!accessResult._everythingIsAccessible) break block8;
                    auditHandler.logAuthzAudits(accessResult._accessAllowedEvents);
                    auditHandler.logAuthzAudits(accessResult._familyLevelAccessEvents);
                    LOG.debug((Object)"authorizeAccess: exiting: No filter returned since all access was allowed");
                    filter = null;
                }
                catch (Throwable throwable) {
                    RangerPerfTracer.log(perf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"<== authorizeAccess");
                    }
                    throw throwable;
                }
                RangerPerfTracer.log((RangerPerfTracer)perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"<== authorizeAccess");
                }
                return filter;
            }
            if (!accessResult._somethingIsAccessible) break block9;
            auditHandler.logAuthzAudits(accessResult._accessAllowedEvents);
            LOG.debug((Object)"authorizeAccess: exiting: Filter returned since some access was allowed");
            RangerAuthorizationFilter rangerAuthorizationFilter = accessResult._filter;
            RangerPerfTracer.log((RangerPerfTracer)perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== authorizeAccess");
            }
            return rangerAuthorizationFilter;
        }
        auditHandler.logAuthzAudit(accessResult._accessDeniedEvent);
        LOG.debug((Object)"authorizeAccess: exiting: Throwing exception since nothing was accessible");
        throw new AccessDeniedException(accessResult._denialReason);
    }

    Filter combineFilters(Filter filter, Filter existingFilter) {
        Filter combinedFilter = filter;
        if (existingFilter != null) {
            combinedFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{filter, existingFilter}));
        }
        return combinedFilter;
    }

    void requirePermission(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment regionServerEnv, Map<byte[], ? extends Collection<?>> familyMap) throws AccessDeniedException {
        RangerDefaultAuditHandler auditHandler;
        ColumnFamilyAccessResult accessResult;
        block4: {
            RangerPerfTracer perf = null;
            try {
                if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HBASEAUTH_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer((Log)PERF_HBASEAUTH_REQUEST_LOG, (String)("RangerAuthorizationCoprocessor.requirePermission(request=Operation[" + operation + "]"));
                }
                accessResult = this.evaluateAccess(ctx, operation, action, regionServerEnv, familyMap);
                auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                if (!accessResult._everythingIsAccessible) break block4;
                auditHandler.logAuthzAudits(accessResult._accessAllowedEvents);
                auditHandler.logAuthzAudits(accessResult._familyLevelAccessEvents);
                LOG.debug((Object)"requirePermission: exiting: all access was allowed");
            }
            catch (Throwable throwable) {
                RangerPerfTracer.log(perf);
                throw throwable;
            }
            RangerPerfTracer.log((RangerPerfTracer)perf);
            return;
        }
        auditHandler.logAuthzAudit(accessResult._accessDeniedEvent);
        LOG.debug((Object)"requirePermission: exiting: throwing exception as everything wasn't accessible");
        throw new AccessDeniedException(accessResult._denialReason);
    }

    void authorizeAccess(ObserverContext<?> ctx, String operation, String otherInformation, Permission.Action action, String table, String columnFamily, String column) throws AccessDeniedException {
        String message;
        String format;
        User user = this.getActiveUser(ctx);
        String access = this._authUtils.getAccess(action);
        if (LOG.isDebugEnabled()) {
            format = "authorizeAccess: %s: Operation[%s], Info[%s], access[%s], table[%s], columnFamily[%s], column[%s]";
            message = String.format("authorizeAccess: %s: Operation[%s], Info[%s], access[%s], table[%s], columnFamily[%s], column[%s]", "Entering", operation, otherInformation, access, table, columnFamily, column);
            LOG.debug((Object)message);
        }
        format = "authorizeAccess: %s: Operation[%s], Info[%s], access[%s], table[%s], columnFamily[%s], column[%s], allowed[%s], reason[%s]";
        if (this.canSkipAccessCheck(user, operation, access, table)) {
            if (LOG.isDebugEnabled()) {
                message = String.format("authorizeAccess: %s: Operation[%s], Info[%s], access[%s], table[%s], columnFamily[%s], column[%s], allowed[%s], reason[%s]", "Exiting", operation, otherInformation, access, table, columnFamily, column, true, "can skip auth check");
                LOG.debug((Object)message);
            }
            return;
        }
        HbaseAuditHandler auditHandler = this._factory.getAuditHandler();
        AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).otherInformation(otherInformation).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access).table(table).columnFamily(columnFamily).column(column).buildRequest().authorize();
        if (LOG.isDebugEnabled()) {
            boolean allowed = session.isAuthorized();
            String reason = session.getDenialReason();
            String message2 = String.format("authorizeAccess: %s: Operation[%s], Info[%s], access[%s], table[%s], columnFamily[%s], column[%s], allowed[%s], reason[%s]", "Exiting", operation, otherInformation, access, table, columnFamily, column, allowed, reason);
            LOG.debug((Object)message2);
        }
        session.publishResults();
    }

    boolean canSkipAccessCheck(User user, String operation, String access, String table) throws AccessDeniedException {
        boolean result = false;
        if (user == null) {
            String message = "Unexpeceted: User is null: access denied, not audited!";
            LOG.warn((Object)("canSkipAccessCheck: exiting" + message));
            throw new AccessDeniedException("No user associated with request (" + operation + ") for action: " + access + "on table:" + table);
        }
        if (this.isAccessForMetadataRead(access, table)) {
            LOG.debug((Object)"canSkipAccessCheck: true: metadata read access always allowed, not audited");
            result = true;
        } else {
            LOG.debug((Object)"Can't skip access checks");
        }
        return result;
    }

    boolean canSkipAccessCheck(User user, String operation, String access, RegionCoprocessorEnvironment regionServerEnv) throws AccessDeniedException {
        if (this.isAccessForMetaTables(regionServerEnv) && this._authUtils.isReadAccess(access)) {
            LOG.debug((Object)"isKnownAccessPattern: exiting: Read access for metadata tables allowed, not audited!");
            return true;
        }
        if (this._authUtils.isWriteAccess(access) && this.isAccessForMetaTables(regionServerEnv)) {
            String createAccess = this._authUtils.getAccess(Permission.Action.CREATE);
            AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).remoteAddress(this.getRemoteAddress()).user(user).access(createAccess).buildRequest().authorize();
            if (session.isAuthorized()) {
                LOG.debug((Object)"isKnownAccessPattern: exiting: User has global create access, allowed!");
                return true;
            }
        }
        return false;
    }

    boolean isAccessForMetadataRead(String access, String table) {
        if (this._authUtils.isReadAccess(access) && this.isSpecialTable(table)) {
            LOG.debug((Object)"isAccessForMetadataRead: Metadata tables read: access allowed!");
            return true;
        }
        return false;
    }

    protected void requireGlobalPermission(ObserverContext<?> ctx, String request, String objName, Permission.Action action) throws AccessDeniedException {
        this.authorizeAccess(ctx, request, objName, action, null, null, null);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, Permission.Action action) throws AccessDeniedException {
        this.requirePermission(ctx, request, null, action);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, byte[] tableName, Permission.Action action) throws AccessDeniedException {
        String table = Bytes.toString((byte[])tableName);
        this.authorizeAccess(ctx, request, null, action, table, null, null);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, byte[] aTableName, byte[] aColumnFamily, byte[] aQualifier, Permission.Action action) throws AccessDeniedException {
        String table = Bytes.toString((byte[])aTableName);
        String columnFamily = Bytes.toString((byte[])aColumnFamily);
        String column = Bytes.toString((byte[])aQualifier);
        this.authorizeAccess(ctx, request, null, action, table, columnFamily, column);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, Permission.Action perm, RegionCoprocessorEnvironment env, Collection<byte[]> families) throws IOException {
        HashMap<byte[], Object> familyMap = new HashMap<byte[], Object>();
        if (families != null) {
            for (byte[] family : families) {
                familyMap.put(family, null);
            }
        }
        this.requirePermission(ctx, request, perm, env, familyMap);
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public Optional<EndpointObserver> getEndpointObserver() {
        return Optional.of(this);
    }

    public Optional<BulkLoadObserver> getBulkLoadObserver() {
        return Optional.of(this);
    }

    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser(c);
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put((InternalScanner)s, user.getShortName());
        }
        return s;
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (UpdateRangerPoliciesOnGrantRevoke) {
            LOG.debug((Object)"Calling create ACL table ...");
            try (Admin admin = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConnection().getAdmin();){
                if (!admin.tableExists(AccessControlLists.ACL_TABLE_NAME)) {
                    RangerAuthorizationCoprocessor.createACLTable(admin);
                }
            }
        }
    }

    private static void createACLTable(Admin admin) throws IOException {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])AccessControlLists.ACL_LIST_FAMILY).setMaxVersions(1).setInMemory(true).setBlockCacheEnabled(true).setBlocksize(8192).setBloomFilterType(BloomType.NONE).setScope(0).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)AccessControlLists.ACL_TABLE_NAME).addColumnFamily(cfd).build();
        admin.createTable(td);
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this));
    }

    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        this.requirePermission(c, "append", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), append.getFamilyCellMap());
        return null;
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "assign", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "balance", Permission.Action.ADMIN);
    }

    public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission(c, "balanceSwitch", Permission.Action.ADMIN);
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        LinkedList<byte[]> cfs = new LinkedList<byte[]>();
        for (Pair<byte[], String> el : familyPaths) {
            cfs.add((byte[])el.getFirst());
        }
        this.requirePermission(ctx, "bulkLoadHFile", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(c, "checkAndDelete", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        this.requirePermission(c, "checkAndDelete", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        return result;
    }

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(c, "checkAndPut", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        this.requirePermission(c, "checkAndPut", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        return result;
    }

    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "cloneSnapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission(e, "close", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), Permission.Action.ADMIN);
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.requirePermission(e, "compact", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
        return scanner;
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker tracker) throws IOException {
        this.requirePermission(e, "compactSelection", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        this.requirePermission(c, "createTable", desc.getTableName().getName(), Permission.Action.CREATE);
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission(c, "delete", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), delete.getFamilyCellMap());
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        this.requirePermission(ctx, "deleteSnapshot", snapshot.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "deleteTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "disableTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "enableTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.requirePermission(c, "exists", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), get.familySet());
        return exists;
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
        this.requirePermission(e, "flush", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.requirePermission(c, "increment", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), increment.getFamilyCellMap().keySet());
        return null;
    }

    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, TableDescriptor htd) throws IOException {
        this.requirePermission(c, "modifyTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission(c, "move", region.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext, long procId) throws IOException {
        this.requirePermission(observerContext, "abortProcedure", Permission.Action.ADMIN);
    }

    public void postGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        this.requirePermission(observerContext, "getProcedures", Permission.Action.ADMIN);
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            RegionInfo regionInfo = region.getRegionInfo();
            if (this.isSpecialTable(regionInfo)) {
                this.requireSystemOrSuperUser(this.regionEnv.getConfiguration(), e);
            } else {
                this.requirePermission(e, "open", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), Permission.Action.ADMIN);
            }
        }
    }

    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "restoreSnapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(c, s);
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(c, s);
        return hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> preScannerOpen");
        }
        try {
            RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
            Map familyMap = scan.getFamilyMap();
            String operation = "scannerOpen";
            Filter filter = this.authorizeAccess(c, operation, Permission.Action.READ, e, familyMap);
            if (filter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"preScannerOpen: Access allowed for all families/column.  No filter added");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"preScannerOpen: Access allowed for some of the families/column. New filter added.");
                }
                Filter existingFilter = scan.getFilter();
                Filter combinedFilter = this.combineFilters(filter, existingFilter);
                scan.setFilter(combinedFilter);
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== preScannerOpen");
            }
        }
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "shutdown", Permission.Action.ADMIN);
    }

    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "snapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "stopMaster", Permission.Action.ADMIN);
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission(env, "stop", Permission.Action.ADMIN);
    }

    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission(c, "unassign", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setUserQuota", null, Permission.Action.ADMIN);
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setUserTableQuota", tableName.getName(), null, null, Permission.Action.ADMIN);
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setUserNamespaceQuota", namespace, Permission.Action.ADMIN);
    }

    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setTableQuota", tableName.getName(), null, null, Permission.Action.ADMIN);
    }

    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setNamespaceQuota", namespace, Permission.Action.ADMIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start(CoprocessorEnvironment env) throws IOException {
        String appType = "unknown";
        this.shouldCheckExecPermission = env.getConfiguration().getBoolean("hbase.security.exec.permission.checks", false);
        if (env instanceof MasterCoprocessorEnvironment) {
            this.coprocessorType = MASTER_COPROCESSOR_TYPE;
            appType = "hbaseMaster";
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            this.coprocessorType = REGIONAL_SERVER_COPROCESSOR_TYPE;
            appType = "hbaseRegional";
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            this.coprocessorType = REGIONAL_COPROCESSOR_TYPE;
            appType = "hbaseRegional";
        }
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        Configuration conf = env.getConfiguration();
        HbaseFactory.initialize(conf);
        RangerHBasePlugin plugin = hbasePlugin;
        if (plugin == null) {
            Class<RangerAuthorizationCoprocessor> clazz = RangerAuthorizationCoprocessor.class;
            // MONITORENTER : org.apache.ranger.authorization.hbase.RangerAuthorizationCoprocessor.class
            plugin = hbasePlugin;
            if (plugin == null) {
                plugin = new RangerHBasePlugin(appType);
                plugin.init();
                UpdateRangerPoliciesOnGrantRevoke = plugin.getConfig().getBoolean("xasecure.hbase.update.xapolicies.on.grant.revoke", true);
                hbasePlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug((Object)("Start of Coprocessor: [" + this.coprocessorType + "]"));
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission(c, "put", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), put.getFamilyCellMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> preGetOp");
        }
        try {
            RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)rEnv.getEnvironment();
            Map familyMap = get.getFamilyMap();
            String operation = "get";
            Filter filter = this.authorizeAccess(rEnv, operation, Permission.Action.READ, e, familyMap);
            if (filter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"preGetOp: all access allowed, no filter returned");
                }
            } else {
                Filter existingFilter = get.getFilter();
                Filter combinedFilter = this.combineFilters(filter, existingFilter);
                get.setFilter(combinedFilter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"preGetOp: partial access, new filter added");
                }
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== preGetOp");
            }
        }
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "regionOffline", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "createNamespace", ns.getName(), Permission.Action.ADMIN);
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission(ctx, "deleteNamespace", namespace, Permission.Action.ADMIN);
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "modifyNamespace", ns.getName(), Permission.Action.ADMIN);
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> postGetTableDescriptors(count(tableNamesList)=%s, count(descriptors)=%s, regex=%s)", tableNamesList == null ? 0 : tableNamesList.size(), descriptors == null ? 0 : descriptors.size(), regex));
        }
        if (CollectionUtils.isNotEmpty(descriptors)) {
            User user = this.getActiveUser(ctx);
            String access = this._authUtils.getAccess(Permission.Action.CREATE);
            HbaseAuditHandler auditHandler = this._factory.getAuditHandler();
            AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation("getTableDescriptors").otherInformation("regex=" + regex).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access);
            Iterator<TableDescriptor> itr = descriptors.iterator();
            while (itr.hasNext()) {
                TableDescriptor htd = itr.next();
                String tableName = htd.getTableName().getNameAsString();
                session.table(tableName).buildRequest().authorize();
                if (session.isAuthorized()) continue;
                ArrayList events = null;
                itr.remove();
                AuthzAuditEvent event = auditHandler.getAndDiscardMostRecentEvent();
                if (event != null) {
                    events = Lists.newArrayList((Object[])new AuthzAuditEvent[]{event});
                }
                auditHandler.logAuthzAudits(events);
            }
            if (descriptors.size() > 0) {
                session.logCapturedEvents();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== postGetTableDescriptors(count(tableNamesList)=%s, count(descriptors)=%s, regex=%s)", tableNamesList == null ? 0 : tableNamesList.size(), descriptors == null ? 0 : descriptors.size(), regex));
        }
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, ClientProtos.PrepareBulkLoadRequest request) throws IOException {
        Collection<byte[]> cfs = null;
        this.requirePermission(ctx, "prePrepareBulkLoad", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, ClientProtos.CleanupBulkLoadRequest request) throws IOException {
        Collection<byte[]> cfs = null;
        this.requirePermission(ctx, "preCleanupBulkLoad", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public void preGrant(ObserverContext<MasterCoprocessorEnvironment> ctx, UserPermission userPermission, boolean mergeExistingPermissions) throws IOException {
        if (UpdateRangerPoliciesOnGrantRevoke) {
            GrantRevokeRequest grData = null;
            try {
                grData = this.createGrantData(userPermission);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler();
                    plugin.grantAccess(grData, (RangerAccessResultProcessor)auditHandler);
                }
            }
            catch (AccessControlException excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                throw new AccessDeniedException((Throwable)excp);
            }
            catch (IOException excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                throw new IOException(excp);
            }
            catch (Exception excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                throw new CoprocessorException(excp.getMessage());
            }
        }
    }

    public void preRevoke(ObserverContext<MasterCoprocessorEnvironment> ctx, UserPermission userPermission) throws IOException {
        if (UpdateRangerPoliciesOnGrantRevoke) {
            GrantRevokeRequest grData = null;
            try {
                grData = this.createRevokeData(userPermission);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler();
                    plugin.revokeAccess(grData, (RangerAccessResultProcessor)auditHandler);
                }
            }
            catch (AccessControlException excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                throw new AccessDeniedException((Throwable)excp);
            }
            catch (IOException excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                throw new IOException(excp);
            }
            catch (Exception excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                throw new CoprocessorException(excp.getMessage());
            }
        }
    }

    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermission && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission(ctx, "invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName((RegionCoprocessorEnvironment)ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    @Deprecated
    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        boolean isSuccess = false;
        if (UpdateRangerPoliciesOnGrantRevoke) {
            GrantRevokeRequest grData = null;
            try {
                grData = this.createGrantData(request);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    plugin.grantAccess(grData, (RangerAccessResultProcessor)auditHandler);
                    isSuccess = true;
                }
            }
            catch (AccessControlException excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new AccessDeniedException((Throwable)excp));
            }
            catch (IOException excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)excp);
            }
            catch (Exception excp) {
                LOG.warn((Object)"grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new CoprocessorException(excp.getMessage()));
            }
        }
        AccessControlProtos.GrantResponse response = isSuccess ? AccessControlProtos.GrantResponse.getDefaultInstance() : null;
        done.run((Object)response);
    }

    @Deprecated
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        boolean isSuccess = false;
        if (UpdateRangerPoliciesOnGrantRevoke) {
            GrantRevokeRequest grData = null;
            try {
                grData = this.createRevokeData(request);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    plugin.revokeAccess(grData, (RangerAccessResultProcessor)auditHandler);
                    isSuccess = true;
                }
            }
            catch (AccessControlException excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new AccessDeniedException((Throwable)excp));
            }
            catch (IOException excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)excp);
            }
            catch (Exception excp) {
                LOG.warn((Object)"revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new CoprocessorException(excp.getMessage()));
            }
        }
        AccessControlProtos.RevokeResponse response = isSuccess ? AccessControlProtos.RevokeResponse.getDefaultInstance() : null;
        done.run((Object)response);
    }

    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        LOG.debug((Object)"checkPermissions(): ");
    }

    public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        LOG.debug((Object)"hasPermission(): ");
    }

    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            Object[] groupArray;
            String operation = "userPermissions";
            RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
            User user = this.getActiveUser(null);
            HashSet groups = this._userUtils.getUserGroups(user);
            if (groups.isEmpty() && user.getUGI() != null && (groupArray = user.getUGI().getGroupNames()) != null) {
                groups = Sets.newHashSet((Object[])groupArray);
            }
            final RangerAccessRequestImpl rangerAccessrequest = new RangerAccessRequestImpl((RangerAccessResource)resource, null, this._userUtils.getUserAsString(user), groups);
            rangerAccessrequest.setAction(operation);
            rangerAccessrequest.setClientIPAddress(this.getRemoteAddress());
            rangerAccessrequest.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF);
            rangerAccessrequest.setClusterName(hbasePlugin.getClusterName());
            List perms = null;
            if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                final TableName table = request.hasTableName() ? ProtobufUtil.toTableName((TableProtos.TableName)request.getTableName()) : null;
                this.requirePermission(null, operation, table.getName(), Permission.Action.ADMIN);
                resource.setValue("table", (Object)table.getNameAsString());
                perms = (List)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

                    @Override
                    public List<UserPermission> run() throws Exception {
                        return RangerAuthorizationCoprocessor.this.getUserPrermissions(hbasePlugin.getCurrentRangerAuthContext().getResourceACLs((RangerAccessRequest)rangerAccessrequest), table.getNameAsString(), false);
                    }
                });
            } else if (request.getType() == AccessControlProtos.Permission.Type.Namespace) {
                final String namespace = request.getNamespaceName().toStringUtf8();
                this.requireGlobalPermission(null, "getUserPermissionForNamespace", namespace, Permission.Action.ADMIN);
                resource.setValue("table", (Object)(namespace + ":"));
                rangerAccessrequest.setRequestData(namespace);
                perms = (List)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

                    @Override
                    public List<UserPermission> run() throws Exception {
                        return RangerAuthorizationCoprocessor.this.getUserPrermissions(hbasePlugin.getCurrentRangerAuthContext().getResourceACLs((RangerAccessRequest)rangerAccessrequest), namespace, true);
                    }
                });
            } else {
                this.requirePermission(null, "userPermissions", Permission.Action.ADMIN);
                perms = (List)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

                    @Override
                    public List<UserPermission> run() throws Exception {
                        return RangerAuthorizationCoprocessor.this.getUserPrermissions(hbasePlugin.getCurrentRangerAuthContext().getResourceACLs((RangerAccessRequest)rangerAccessrequest), null, false);
                    }
                });
                if (this._userUtils.isSuperUser(user)) {
                    Permission.Builder b = Permission.newBuilder((TableName)AccessControlLists.ACL_TABLE_NAME);
                    b.withActions(Permission.Action.values());
                    perms.add(new UserPermission(this._userUtils.getUserAsString(user), b.build()));
                }
            }
            response = AccessControlUtil.buildGetUserPermissionsResponse((List)perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    private List<UserPermission> getUserPrermissions(RangerResourceACLs rangerResourceACLs, String resource, boolean isNamespace) {
        ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
        Permission.Action[] hbaseActions = Permission.Action.values();
        ArrayList<String> hbaseActionsList = new ArrayList<String>();
        for (Permission.Action action : hbaseActions) {
            hbaseActionsList.add(action.name());
        }
        this.addPermission(rangerResourceACLs.getUserACLs(), isNamespace, hbaseActionsList, userPermissions, resource, false);
        this.addPermission(rangerResourceACLs.getGroupACLs(), isNamespace, hbaseActionsList, userPermissions, resource, true);
        return userPermissions;
    }

    private void addPermission(Map<String, Map<String, RangerResourceACLs.AccessResult>> acls, boolean isNamespace, List<String> hbaseActionsList, List<UserPermission> userPermissions, String resource, boolean isGroup) {
        for (Map.Entry<String, Map<String, RangerResourceACLs.AccessResult>> userAcls : acls.entrySet()) {
            String user = !isGroup ? userAcls.getKey() : AuthUtil.toGroupEntry((String)userAcls.getKey());
            ArrayList<Permission.Action> allowedPermissions = new ArrayList<Permission.Action>();
            for (Map.Entry<String, RangerResourceACLs.AccessResult> permissionAccess : userAcls.getValue().entrySet()) {
                String permission = permissionAccess.getKey().toUpperCase();
                if (!hbaseActionsList.contains(permission) || permissionAccess.getValue().getResult() != RangerPolicyEvaluator.ACCESS_ALLOWED.intValue()) continue;
                allowedPermissions.add(Permission.Action.valueOf((String)permission));
            }
            if (allowedPermissions.isEmpty()) continue;
            UserPermission up = null;
            Permission.Builder b = null;
            if (isNamespace) {
                b = Permission.newBuilder((String)resource);
                b.withActions(allowedPermissions.toArray(new Permission.Action[allowedPermissions.size()]));
                up = new UserPermission(user, b.build());
            } else {
                b = Permission.newBuilder((TableName)TableName.valueOf((String)resource));
                b.withActions(allowedPermissions.toArray(new Permission.Action[allowedPermissions.size()]));
                up = new UserPermission(user, b.build());
            }
            userPermissions.add(up);
        }
    }

    private GrantRevokeRequest createGrantData(AccessControlProtos.GrantRequest request) throws Exception {
        GrantRevokeRequest ret = null;
        AccessControlProtos.UserPermission up = request.getUserPermission();
        UserPermission perm = up == null ? null : AccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)up);
        ret = this.createRevokeData(perm);
        return ret;
    }

    private GrantRevokeRequest createGrantData(UserPermission userPermission) throws Exception {
        User activeUser;
        AccessControlProtos.Permission perm = userPermission == null ? null : AccessControlUtil.toPermission((Permission)userPermission.getPermission());
        Permission.Action[] actions = userPermission == null ? null : userPermission.getPermission().getActions();
        String userName = userPermission == null ? null : userPermission.getUser();
        String nameSpace = null;
        String tableName = null;
        String colFamily = null;
        String qualifier = null;
        if (perm == null) {
            throw new Exception("grant(): invalid data - permission is null");
        }
        if (StringUtil.isEmpty((String)userName)) {
            throw new Exception("grant(): invalid data - username empty");
        }
        if (actions == null || actions.length == 0) {
            throw new Exception("grant(): invalid data - no action specified");
        }
        switch (perm.getType()) {
            case Global: {
                qualifier = "*";
                colFamily = "*";
                tableName = "*";
                break;
            }
            case Table: {
                TablePermission tablePerm = (TablePermission)userPermission.getPermission();
                tableName = Bytes.toString((byte[])tablePerm.getTableName().getName());
                colFamily = Bytes.toString((byte[])tablePerm.getFamily());
                qualifier = Bytes.toString((byte[])tablePerm.getQualifier());
                break;
            }
            case Namespace: {
                NamespacePermission namespacePermission = (NamespacePermission)userPermission.getPermission();
                nameSpace = namespacePermission.getNamespace();
            }
        }
        if (StringUtil.isEmpty(nameSpace) && StringUtil.isEmpty(tableName) && StringUtil.isEmpty((String)colFamily) && StringUtil.isEmpty((String)qualifier)) {
            throw new Exception("grant(): namespace/table/columnFamily/columnQualifier not specified");
        }
        tableName = StringUtil.isEmpty(tableName) ? "*" : tableName;
        colFamily = StringUtil.isEmpty((String)colFamily) ? "*" : colFamily;
        String string = qualifier = StringUtil.isEmpty((String)qualifier) ? "*" : qualifier;
        if (!StringUtil.isEmpty((String)nameSpace)) {
            tableName = nameSpace + ":" + tableName;
        }
        String grantor = (activeUser = this.getActiveUser(null)) != null ? activeUser.getShortName() : null;
        String[] groups = activeUser != null ? activeUser.getGroupNames() : null;
        HashSet<String> grantorGroups = null;
        if (groups != null && groups.length > 0) {
            grantorGroups = new HashSet<String>(Arrays.asList(groups));
        }
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("table", tableName);
        mapResource.put("column-family", colFamily);
        mapResource.put("column", qualifier);
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(grantor);
        ret.setGrantorGroups(grantorGroups);
        ret.setDelegateAdmin(Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.TRUE);
        ret.setResource(mapResource);
        ret.setClientIPAddress(this.getRemoteAddress());
        ret.setForwardedAddresses(null);
        ret.setRemoteIPAddress(this.getRemoteAddress());
        ret.setRequestData(userPermission.toString());
        if (userName.startsWith(GROUP_PREFIX)) {
            ret.getGroups().add(userName.substring(GROUP_PREFIX.length()));
        } else {
            ret.getUsers().add(userName);
        }
        block11: for (Permission.Action action : actions) {
            switch (action.code()) {
                case 82: {
                    ret.getAccessTypes().add("read");
                    continue block11;
                }
                case 87: {
                    ret.getAccessTypes().add("write");
                    continue block11;
                }
                case 67: {
                    ret.getAccessTypes().add("create");
                    continue block11;
                }
                case 65: {
                    ret.getAccessTypes().add("admin");
                    ret.setDelegateAdmin(Boolean.TRUE);
                    continue block11;
                }
                default: {
                    LOG.warn((Object)("grant(): ignoring action '" + action.name() + "' for user '" + userName + "'"));
                }
            }
        }
        return ret;
    }

    private GrantRevokeRequest createRevokeData(AccessControlProtos.RevokeRequest request) throws Exception {
        GrantRevokeRequest ret = null;
        AccessControlProtos.UserPermission up = request.getUserPermission();
        UserPermission perm = up == null ? null : AccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)up);
        ret = this.createRevokeData(perm);
        return ret;
    }

    private GrantRevokeRequest createRevokeData(UserPermission userPermission) throws Exception {
        User activeUser;
        AccessControlProtos.Permission perm = userPermission == null ? null : AccessControlUtil.toPermission((Permission)userPermission.getPermission());
        String userName = userPermission == null ? null : userPermission.getUser();
        String nameSpace = null;
        String tableName = null;
        String colFamily = null;
        String qualifier = null;
        if (perm == null) {
            throw new Exception("revoke(): invalid data - permission is null");
        }
        if (StringUtil.isEmpty((String)userName)) {
            throw new Exception("revoke(): invalid data - username empty");
        }
        switch (perm.getType()) {
            case Global: {
                qualifier = "*";
                colFamily = "*";
                tableName = "*";
                break;
            }
            case Table: {
                TablePermission tablePerm = (TablePermission)userPermission.getPermission();
                tableName = Bytes.toString((byte[])tablePerm.getTableName().getName());
                colFamily = Bytes.toString((byte[])tablePerm.getFamily());
                qualifier = Bytes.toString((byte[])tablePerm.getQualifier());
                break;
            }
            case Namespace: {
                NamespacePermission namespacePermission = (NamespacePermission)userPermission.getPermission();
                nameSpace = namespacePermission.getNamespace();
            }
        }
        if (StringUtil.isEmpty(nameSpace) && StringUtil.isEmpty(tableName) && StringUtil.isEmpty((String)colFamily) && StringUtil.isEmpty((String)qualifier)) {
            throw new Exception("revoke(): table/columnFamily/columnQualifier not specified");
        }
        tableName = StringUtil.isEmpty(tableName) ? "*" : tableName;
        colFamily = StringUtil.isEmpty((String)colFamily) ? "*" : colFamily;
        String string = qualifier = StringUtil.isEmpty((String)qualifier) ? "*" : qualifier;
        if (!StringUtil.isEmpty((String)nameSpace)) {
            tableName = nameSpace + ":" + tableName;
        }
        String grantor = (activeUser = this.getActiveUser(null)) != null ? activeUser.getShortName() : null;
        String[] groups = activeUser != null ? activeUser.getGroupNames() : null;
        HashSet<String> grantorGroups = null;
        if (groups != null && groups.length > 0) {
            grantorGroups = new HashSet<String>(Arrays.asList(groups));
        }
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("table", tableName);
        mapResource.put("column-family", colFamily);
        mapResource.put("column", qualifier);
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(grantor);
        ret.setGrantorGroups(grantorGroups);
        ret.setDelegateAdmin(Boolean.TRUE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.TRUE);
        ret.setResource(mapResource);
        ret.setClientIPAddress(this.getRemoteAddress());
        ret.setForwardedAddresses(null);
        ret.setRemoteIPAddress(this.getRemoteAddress());
        ret.setRequestData(userPermission.toString());
        if (userName.startsWith(GROUP_PREFIX)) {
            ret.getGroups().add(userName.substring(GROUP_PREFIX.length()));
        } else {
            ret.getUsers().add(userName);
        }
        ret.getAccessTypes().add("read");
        ret.getAccessTypes().add("write");
        ret.getAccessTypes().add("create");
        ret.getAccessTypes().add("admin");
        return ret;
    }

    static class ColumnFamilyAccessResult {
        final boolean _everythingIsAccessible;
        final boolean _somethingIsAccessible;
        final List<AuthzAuditEvent> _accessAllowedEvents;
        final List<AuthzAuditEvent> _familyLevelAccessEvents;
        final AuthzAuditEvent _accessDeniedEvent;
        final String _denialReason;
        final RangerAuthorizationFilter _filter;

        ColumnFamilyAccessResult(boolean everythingIsAccessible, boolean somethingIsAccessible, List<AuthzAuditEvent> accessAllowedEvents, List<AuthzAuditEvent> familyLevelAccessEvents, AuthzAuditEvent accessDeniedEvent, String denialReason, RangerAuthorizationFilter filter) {
            this._everythingIsAccessible = everythingIsAccessible;
            this._somethingIsAccessible = somethingIsAccessible;
            this._accessAllowedEvents = accessAllowedEvents;
            this._familyLevelAccessEvents = familyLevelAccessEvents;
            this._accessDeniedEvent = accessDeniedEvent;
            this._denialReason = denialReason;
            this._filter = filter;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("everythingIsAccessible", this._everythingIsAccessible).add("somethingIsAccessible", this._somethingIsAccessible).add("accessAllowedEvents", this._accessAllowedEvents).add("familyLevelAccessEvents", this._familyLevelAccessEvents).add("accessDeniedEvent", (Object)this._accessDeniedEvent).add("denialReason", (Object)this._denialReason).add("filter", (Object)this._filter).toString();
        }
    }
}

