/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.ranger.authorization.hbase.HbaseAuthUtils;

public class HbaseAuthUtilsImpl
implements HbaseAuthUtils {
    private static final Log LOG = LogFactory.getLog((String)HbaseAuthUtilsImpl.class.getName());

    @Override
    public String getAccess(Permission.Action action) {
        switch (action) {
            case READ: {
                return "read";
            }
            case WRITE: {
                return "write";
            }
            case CREATE: {
                return "create";
            }
            case ADMIN: {
                return "admin";
            }
            case EXEC: {
                return "execute";
            }
        }
        return action.name().toLowerCase();
    }

    @Override
    public boolean isReadAccess(String access) {
        return this.getAccess(Permission.Action.READ).equals(access);
    }

    @Override
    public boolean isWriteAccess(String access) {
        return this.getAccess(Permission.Action.WRITE).equals(access);
    }

    @Override
    public boolean isExecuteAccess(String access) {
        return this.getAccess(Permission.Action.EXEC).equals(access);
    }

    @Override
    public String getTable(RegionCoprocessorEnvironment regionServerEnv) {
        RegionInfo hri = regionServerEnv.getRegion().getRegionInfo();
        byte[] tableName = hri.getTable().getName();
        String tableNameStr = Bytes.toString((byte[])tableName);
        if (LOG.isDebugEnabled()) {
            String message = String.format("getTable: Returning tablename[%s]", tableNameStr);
            LOG.debug((Object)message);
        }
        return tableNameStr;
    }
}

