/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.RangerHBaseResource;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class HbaseAuditHandlerImpl
extends RangerDefaultAuditHandler
implements HbaseAuditHandler {
    private static final Log LOG = LogFactory.getLog(HbaseAuditHandlerImpl.class);
    static final List<AuthzAuditEvent> _EmptyList = new ArrayList<AuthzAuditEvent>();
    final List<AuthzAuditEvent> _allEvents = new ArrayList<AuthzAuditEvent>();
    AuthzAuditEvent _mostRecentEvent = null;
    boolean _superUserOverride = false;

    public AuthzAuditEvent getAuthzEvents(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.getAuthzEvents(" + result + ")"));
        }
        this.resetResourceForAudit(result.getAccessRequest());
        AuthzAuditEvent event = super.getAuthzEvents(result);
        if (this._mostRecentEvent != null) {
            LOG.debug((Object)"getAuthzEvents: got one event from default audit handler");
            this._allEvents.add(this._mostRecentEvent);
        } else {
            LOG.debug((Object)"getAuthzEvents: no event produced by default audit handler");
        }
        this._mostRecentEvent = event;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getAuthzEvents: mostRecentEvent:" + this._mostRecentEvent));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseAuditHandlerImpl.getAuthzEvents(" + result + "): null"));
        }
        return null;
    }

    @Override
    public List<AuthzAuditEvent> getCapturedEvents() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HbaseAuditHandlerImpl.getCapturedEvents()");
        }
        ArrayList<AuthzAuditEvent> result = new ArrayList<AuthzAuditEvent>(this._allEvents);
        if (this._mostRecentEvent != null) {
            result.add(this._mostRecentEvent);
        }
        this.applySuperUserOverride(result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseAuditHandlerImpl.getAuthzEvents(): count[" + result.size() + "] :result : " + result));
        }
        return result;
    }

    @Override
    public AuthzAuditEvent getAndDiscardMostRecentEvent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HbaseAuditHandlerImpl.getAndDiscardMostRecentEvent():");
        }
        AuthzAuditEvent result = this._mostRecentEvent;
        this.applySuperUserOverride(result);
        this._mostRecentEvent = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseAuditHandlerImpl.getAndDiscardMostRecentEvent(): " + result));
        }
        return result;
    }

    @Override
    public void setMostRecentEvent(AuthzAuditEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.setMostRecentEvent(" + event + ")"));
        }
        this._mostRecentEvent = event;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HbaseAuditHandlerImpl.setMostRecentEvent(...)");
        }
    }

    @Override
    public void setSuperUserOverride(boolean override) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.setSuperUserOverride(" + override + ")"));
        }
        this._superUserOverride = override;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HbaseAuditHandlerImpl.setSuperUserOverride(...)");
        }
    }

    void applySuperUserOverride(List<AuthzAuditEvent> events) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.applySuperUserOverride(" + events + ")"));
        }
        for (AuthzAuditEvent event : events) {
            this.applySuperUserOverride(event);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HbaseAuditHandlerImpl.applySuperUserOverride(...)");
        }
    }

    void applySuperUserOverride(AuthzAuditEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.applySuperUserOverride(" + event + ")"));
        }
        if (event != null && this._superUserOverride) {
            event.setAccessResult((short)1);
            event.setPolicyId(-1L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HbaseAuditHandlerImpl.applySuperUserOverride(...)");
        }
    }

    private void resetResourceForAudit(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HbaseAuditHandlerImpl.resetResourceForAudit(" + request + ")"));
        }
        if (request != null && request.getResource() instanceof RangerHBaseResource) {
            RangerHBaseResource hbaseResource = (RangerHBaseResource)request.getResource();
            hbaseResource.resetValue("table");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HbaseAuditHandlerImpl.resetResourceForAudit(" + request + ")"));
        }
    }
}

